function S=TrImpSampMod(doo,P)
%Important Sampling Mod of one Directory
%Part 3/3 (after creation of FeStMod.mat for every training folder).
%

%
switch P.TeOpt1
    case 0
        E='y';        
    case 1
        E='x';
end

%Juan To Grid Root and Feat Root
GridRoot='/home/jmorales/Mnt/GRIDData3';
JuanRoot='/home/jmorales';
do=strrep(doo, JuanRoot, GridRoot);

%FeatRoot and TrDir 
[p1,b1]=fileparts(do); [p2,b2]=fileparts(p1); [p3,b3]=fileparts(p2); 
FeatRoot=p2; 
%TrDir=P.TrDir(1:4); %Dev not used
TrDir={'Tr/tr05_bus_simu'  'Tr/tr05_caf_simu' 'Tr/tr05_ped_simu'  'Tr/tr05_str_simu'};

%Load from Juan (first, copy from Grid to Juan)
l=length(TrDir);
for i=1:l
    
    %Copy from Grid to Juan
    GDir=[FeatRoot '/' TrDir{i}];
    JDir=strrep(GDir, GridRoot,JuanRoot);    
    system(['mkdir -p ' JDir]);     
    GF=[GDir '/FeStMod' E '.mat'];   
    JF=[JDir '/FeStMod' E '.mat'];       
    fprintf('Copying.... %s to %s\n',GF,JF);
    copyfile(GF,JF);
    fprintf('Copied %s\n',JF);  
    
    %Load
    S=load(JF);   
    %MC{i}=S.M;
    %VC{i}=S.V;
    PSC{i}=S.PS;
    FWC{i}=S.FW;
    VWC{i}=S.VW;   
end

%Comput
PS=SumC(PSC);
FW=SumC(FWC);
VW=SumC(VWC);
[M,V]=TrImpSampModComp(PS,FW,VW);

%Save
[x,x,x]=mkdir(P.ImpSamMDir);
FeStMod=[P.ImpSamMDir '/FeStMod' E '.mat'];
save(FeStMod,'M','V','PS','FW','VW');
fprintf('Written Import Sampling model in %s\n',FeStMod);

%
% subplot(211), jimagesc(M)
% subplot(212), jimagesc(V)
% pause




S='-1';

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function SC=SumC(C)
%
l=length(C);
SC=zeros(size(C{1}));
for i=1:l
    SC=SC+C{i};
end

