function LP=LogMvnPdf1DataMD(y,ma,Me,Si,f,kind)
%Equivalent to LPr=log(mvnpdf(y',M(:,i)',V(:,i)'))   
%x: data, a column vector
%Me: Mean Matrix (each column is Gaussian and has the same dim as x)
%Si: Std (not Var)

[FL,NG]=size(Me);


%
Y=repmat(y,[1,NG]);
a=(Y-Me)./Si;
LPr=-0.5*(a.^2+log(2*pi))-log(Si);

%
%
% ty=(Y-Me)./(sqrt(2)*Si);
% tf=(MF-Me)./(sqrt(2)*Si);
% d=erf(ty)-erf(tf); i=d<=0; d(i)=realmin; %do it more stable with log
% LPu=log(0.5)+log(d);
%

a=normcdf(Y,Me,Si)-normcdf(f,Me,Si);
LPu=log(a);

%
LP=LPu;
LP(ma,:)=LPr(ma,:);
LP=sum(LP);


