function LPr=LogMvnPdf(X,M,V)
%Log Mvn Pdf
%Equivalent to log(mvnpdf) but more stable and
%the input are matrix which columns are frames

i=V<0; a=sum(i(:)); if a>0; fprintf('WARNING in DrawGausSamp: some V <0\n'); end
LPr=LogMvnPdf2(X,M,V);


% %For comparisons
% LPr2=zeros(1,nf);
% for f=1:nf 
%     LPr2(f)=log(mvnpdf(X(:,f)',M(:,f)',V(:,f)'));    
% end
% subplot(411), jimagesc(X)
% subplot(412), jimagesc(M)
% subplot(413), jimagesc(V)
% subplot(414), plot(LPr), hold on, plot(LPr2,'r'), hold off
% sum(exp(LPr))
% sum(exp(LPr2))
% pause

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function lp=LogMvnPdf2(x,m,v)
%Equivalent to log(mvnpdf) but more stable and
%the input are matrix which columns are frames
k=size(x,1);
a3=1./v;
a4=((x-m).^2);
a=sum(a4.*a3);
c2=k*log(2*pi);
c=(sum(log(v))+c2);
lp=-0.5*(a+c);






