function LcM=LogDot(LaM,LbM)
%Log Dot product using Logs (column by column)
%La=log(a); Lb=log(b); then Lc=log(dot(a,b));
%but more estable process if a and b are huge.
%Also works for 3D arrays (LaM,LbM) 
%Other interpretation: a=exp(La); b=exp(Lb); Lc=log(dot(a,b)) %Equivalent to Lc
[FL,nf]=size(LaM);
LsM=LaM+LbM; %No inf
LmaxV=max(LsM); %-35.6586
%
%LmaxV(isinf(LmaxV))=0; %add this line to work for -Inf
%
LmaxM=repmat(LmaxV,[FL,1]);
a=exp(LsM-LmaxM); %No Inf
LcM=LmaxV+log(sum(a,1)); %In log the inf can appears 


