function [M,V,LC] = GausProd(M1,V1,M2,V2)

[FL,nf]=size(M1);
[FL2,nf]=size(V1);

M=zeros(FL,nf);
V=zeros(FL2,nf);
LC=zeros(1,nf);

for f=1:nf
    [M(:,f),V(:,f),LC(f)] = GausPr1V(M1(:,f),V1(:,f),M2(:,f),V2(:,f));
end






%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [M,V,LC] = GausPr1V(M1,V1,M2,V2)
%Gaussians Product
%Input: means and variances (full or diag) of 2 Gaussians 
% For full case
% M1 = Nx1 vector
% M2 = Nx1 vector
% V1 = N*N matrix
% V2 = N*N matrix
%Output: means and variances of the product of the 2 Gaussians (full or diag)

% %Full
%     M = inv(inv(V1) + inv(V2))*(inv(V1)*M1 + inv(V2)*M2);
%     V = inv(inv(V1) + inv(V2));
%     C = 1./(det(2.*pi.*(V1+V2))).*exp(-0.5.*(M1-M2)'*inv(V1+V2)*(M1-M2));




%Diag
M = (V1.^-1 + V2.^-1).^-1.*(V1.^-1.*M1 + V2.^-1.*M2);
V = (V1.*V2)./(V1+V2);


%LC = log(1./sqrt(det(diag(2.*pi.*(V1+V2)))).*exp(-0.5.*(M1-M2)'*diag((V1+V2).^-1)*(M1-M2)))
LC = log(1) -0.5*sum(log(2.*pi.*(V1+V2)))   +   (-0.5.*sum((M1-M2).^2./(V1+V2)));


