function [LPoxC,PoxC,w]=MCImpSamp(Y,U,config,nnet,P)
%FUTURE: output have to be X3D (and try to avoid context here. not use config and nnet) 


%%%%%%%%%%%%%
X=P.Temp.Fbx;
%%%%%%%%%%%%%

%Read models
[Mod]=ReFeStMod(P);



%Aply context
Fey=nnet_applyContext(Y,config,'feat');
Fex=nnet_applyContext(X,config,'feat');
Uny=nnet_applyContext(U,config,'unc');

%Posteriors
[LPoy,Poy]=nnet_forward(nnet,Fey);  

%
NSamp=3;
[ns,nf]=size(Poy);
LPoxC=cell(NSamp,1);
PoxC=cell(NSamp,1);


%Draw states (from peaking Poy)
[StSamp,NZSt,NZP]=DrawSampPdf(Poy,NSamp);



for i=1:NSamp
        
    %1) Draw a state
    St=StSamp(i,:);


    %2) Draw a sample (and its probability) using model-state and uncertainty    
    [Fexi,LPxi,LC]=DrawFeat(Fey,Uny,Mod.M(:,St),Mod.V(:,St));
    

    %3) Posterior of sample
    [LPoxi,Poxi]=nnet_forward(nnet,Fexi);    

    


    %4) Uncertainty of sample and its probability
    LPxiy=LogMvnPdf(Fexi,Fey,Uny);
    
    %5) Proposal distribution. Prob of the sample (q(xi))
    LQxi=LogPdfPropDist(Fey,Fexi,Uny,Mod.M,Mod.V,NZSt,NZP);
    
    %6) Log weight 
    Lwxi=LPxiy-LQxi;
    LwxiM=repmat(Lwxi,[ns,1]);
    wxiM=exp(LwxiM);


    %Weigth posteriors    
    %LPoxiw=LPoxi+LwxiM;
    Poxiw=Poxi.*wxiM;
    %sum(Poxiw)

    %Normalization
%     Poxiw=exp(LPoxiw);
%     Ls=log(sum(Poxiw)); 
%     LPoxiwn=log(Poxiw)-repmat(Ls,[ns,1]);
%      Poxiwn=Poxiw./repmat(sum(Poxiw),[ns,1]);  

    subplot(711), jimagesc(Fey), title('Noisy (Y)')    
    subplot(712), jimagesc(Fex), title('Clean (X)')
    subplot(713), jimagesc(Uny), title('Uncertainty of noisy (U=(Y-X)^2)')      
    subplot(714), jimagesc(Fexi), title('Clean sample (Xi)')           
    subplot(715), jimagesc(log(Poxi)), title('Log posterior of clean sample (p(s|xi))')     
    subplot(716), plot(Lwxi), hold on, plot(LPxiy,'r'), plot(LQxi,'g'), plot(LPxi,'k'), hold off, xlim([1 length(Lwxi)])
    title('Log Weight of clean sample (w(xi)=p(xi|y)/q(xi))'), 
    legend('w(xi)=p(xi|y)/q(xi) (weight)','p(xi|y) (uncert)','q(xi) (prop distrib)', 'p(xi) (prob of clean sample)' ) 
    subplot(717), jimagesc(log(Poxiw)), title('Log posterior of clean sample weigthed (p(s|xi)*w(xi))') 
    pause
    

    

    
    
    
end
w=[1 1 1];





%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%Fex%%%%%%%%%%%%%%%%%%%%%%%%
function [X,LPr,LC]=DrawFeat(Y,U,ModM,ModV)
%
[M,V,LC]=GausProd(ModM,ModV,Y,U); %C can be 0!!!!!!!
[X,LPr]=DrawGausSamp(M,V);


% subplot(411), jimagesc(Y)
% subplot(412), jimagesc(X)
% subplot(413), jimagesc(M)
% subplot(414), jimagesc(V)
% pause


function [Mod]=ReFeStMod(P)
%Read State Gaussians
FeStMod=[P.ImpSamMDir '/FeStMody.mat'];
S=load(FeStMod);
Mod.M=S.M;
Mod.V=S.V;

%Mod.V=1000000*ones(size(Mod.V));

% subplot(211), jimagesc(Mod.M), title('Means (u(x|s)')
% subplot(212), jimagesc(Mod.V), title('Covariances (diag) (V(x|s)')
% pause









