function LQ=LogPdfPropDist(Y,X,U,ModM,ModV,NZSt,NZP)
%Log Pdf of Proposal Distribution



[FL,nf]=size(X);
LQ=zeros(1,nf);
fprintf('LogPropPdf of %d:\n',nf);

for n=1:nf     
    fprintf('%d ',n); if mod(n,30)==0; fprintf('\n'); end        
    
    %
    St=NZSt{n};  
    NSt=length(St);    
    LGam=log(NZP{n}); %Log of Gammas    
    %
    ModMSt=ModM(:,St);
    ModVSt=ModV(:,St); 
    YSt=repmat(Y(:,n),[1,NSt]);   
    XSt=repmat(X(:,n),[1,NSt]);
    USt=repmat(U(:,n),[1,NSt]);    
    
      
    
    [M,V,LC]=GausProd(ModMSt,ModVSt,YSt,USt); %C can be 0!!!!!!!   

    %LN=LogMvnPdf(XSt,M,V)+LC; %Log of Normals Dung  
    LN=LogMvnPdf(XSt,M,V); %Log of Normals   Emmanuel

     
    %Dot product in log to avoid instabilities (FUTURE: put in a function)
    Ls=LGam+LN;
    Lmax=max(Ls);    
    a=Lmax+log(sum(exp(Ls-Lmax)));
    %b=log(sum(exp(LGam+LN))); %b is equivalent to a
    LQ(n)=a;     
end
fprintf('\n');


% subplot(411), jimagesc(X)
% subplot(412), jimagesc(U)
% subplot(413), plot(LQ)
% subplot(414), plot(LPx)
% pause
