function [M,V,PS,FW,VW]=FePoL2FeStMod(FLi,PLi,config)
%Features Posterior Lists To Features State Model

%Feaure Length and Number of States
Fb=ReHtkCont(FLi{1},config);
StPr=ReadHTKF(PLi{1},0,0);
FL=size(Fb,1);
%FL2=FL*FL; %full
FL2=FL; %diag
NS=size(StPr,1);

%
PS=zeros(1,NS); %Posterior Sum
FW=zeros(FL,NS); %Features Weighted
VW=zeros(FL2,NS); %Variances Weighted

%
l=length(FLi); 
for i=1:l
    fprintf('Computing %d/%d.... %s\n',i,l,PLi{i});
    
    %Read files
    Fb=ReHtkCont(FLi{i},config);
    StPr=ReadHTKF(PLi{i},0,0);
    
    %Check if Posterior Sum is [0.99,1.01]
    s=sum(StPr); a=(s<0.99|s>1.01); if sum(a)>0; fprintf('WARNING in FePoL2FeStMod: some posterior sum ~=1 in %s\n',PLi{i}); end
            
    %
    PS=PS+CompPS(StPr);
    FW=FW+CompFW(Fb,StPr,FL,NS);  
    VW=VW+CompVW(Fb,StPr,FL,NS);      
    
end

%Compute Model for this directory
[M,V]=TrImpSampModComp(PS,FW,VW);

% subplot(211), imagesc(M)
% subplot(212), imagesc(V)
% pause



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [VW]=CompVW(Fb,StPr,FL,NS)
%Compute Variances Weighted
NF=size(Fb,2);
%FL2=FL*FL; %full
FL2=FL; %diag
%Obatin Si for all frames as 
Si=zeros(FL2,NF);
for n=1:NF
    x=Fb(:,n);   
    %m=x*x'; v=reshape(m,FL2,1);   %To reconvert as matrix: m=reshape(v,FL,FL);
    v=x.^2; %diag
    Si(:,n)=v;
end
%
[VW]=CompFW(Si,StPr,FL2,NS); %slow 


function [FW]=CompFW(Fb,StPr,FL,NS)
%Compute Features Weigthed
%Loop in s faster than in n
FW=zeros(FL,NS);
for s=1:NS
    %Product for each state
    a=StPr(s,:)';    
    Fbs=Fb*a;   
    FW(:,s)=sum(Fbs,2);
end



function PS=CompPS(StPr)
%
PS=sum(StPr,2)';


function Fe=ReHtkCont(fn,config)
%Read Htk and apply Context
Fb=ReadHTKF(fn,0,0);
%Fe=Fb;
Fe=nnet_applyContext(Fb,config,'feat');



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% function [VW]=CompVWOrig(Fb,StPr,FL,NS)
% %
% NF=size(Fb,2);
% VW=zeros(FL,FL,NS);
% for n=1:NF
%     x=Fb(:,n);   
%     S=x*x';    
%     for s=1:NS        
%         VW(:,:,s)=VW(:,:,s)+StPr(s,n)*S;        
%     end   
% end
% 
% 
% function [FW]=CompFWOrig(Fb,StPr,FL,NS)
% %
% NF=size(Fb,2);
% FW=zeros(FL,NS);
% for n=1:NF
%     x=Fb(:,n);     
%     for s=1:NS
%         FW(:,s)=FW(:,s)+StPr(s,n)*x;
%     end   
% end

    





