function [X3D,w]=EnMCMDSamp(Y,U,k,P)
%Entire, Monte Carlo or Missing Data Sampling
%



switch k
    case 'MC'  
        NSamp=60;
        [X3D,LP,w]=DrawSamp(NSamp,'Gaus',Y,U,P);
        
    case 'MD'
        NSamp=60;
        [X3D,LP,w]=DrawSamp(NSamp,'Unif',Y,U,P);
                
    case 'En'    
        NSamp=3;
        [X3D,LP,w]=DrawSamp(NSamp,'En',Y,U,P);
        
end




%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [X3D,LP,w]=DrawSamp(NSamp,k,Y,U,P)
%

[FL,nf]=size(Y);
X3D=zeros(NSamp,FL,nf);
LP=cell(NSamp,1);

fprintf('%s with %d samples\n',k,NSamp);

    fprintf('DrawSamp: %s\n',k);
    switch k
        
        case 'Gaus'              
            w=ones(1,NSamp)/NSamp;            
            for i=1:NSamp 
                [X3D(i,:,:),LPr]=DrawGausSamp(Y,U); %Pr very small!!!!!!!!!!!!!                 
            end       
                      
            
            
            
        case 'Unif'       
            U=logical(U);
            w=ones(1,NSamp)/NSamp;
    
            
            for i=1:NSamp
                MF=P.MF;
                [FL,nf]=size(Y);
                Y2=(MF+(Y-MF)).*rand(FL,nf);
                Y3=Y2; Y3(U)=Y(U); %at U=1 (reliable), we subtitute by Y; 
                X3D(i,:,:)=Y3;           
%                     subplot(411), jimagesc(Y)
%                     subplot(412), jimagesc(Y2)
%                     subplot(413), jimagesc(Y3)
%                     subplot(414), jimagesc(U)
%                     pause
            end
            
            
            
        case 'En'
            w=[4 1 1]/6;            
            X3D(1,:,:)=Y;
            X3D(2,:,:)=Y+sqrt(3)*sqrt(U);
            X3D(3,:,:)=Y-sqrt(3)*sqrt(U);
            
            
        case 'Pdf'
            
    end
    
    
%     [M,V]=MeVa3DM(X3D);    
%     subplot(411), jimagesc(Y), title('Feature')
%     subplot(412), jimagesc(M), title(['Mean of ' num2str(NSamp) ' MC samples'])
%     subplot(413), jimagesc(U), title('Uncertainty')    
%     subplot(414), jimagesc(V), title(['Variance of ' num2str(NSamp) ' MC samples'])
%     pause







