function [M,V,LW,GS,GE]=PdfSt2Ma(Pdfs)
%Fron Pdf Structure 2 pdf Matrix
%Fast. Put in a Matrix all the Means, Variances and Weights
%V: is the variance (obviously not Std)

NSt=length(Pdfs);

%
GS=zeros(1,NSt);
GE=zeros(1,NSt);
V=[]; M=[]; LW=[];
for s=1:NSt  
    %
    TLW=log(Pdfs{s}.Weights);    
    Means_invvars=Pdfs{s}.Means_invvars;    
    Inv_vars=Pdfs{s}.Inv_vars;         
    %
    TV=1./Inv_vars; %Temporal Variances
    TM=Means_invvars./Inv_vars;    %Temporal Means
    GS(s)=length(LW)+1; %Gaussian Start
    V=[V TV];
    M=[M TM];
    LW=[LW TLW];
    GE(s)=length(LW);    %Gaussian End
end
