function PseudoLL=GmmLogLikUnc(Fe,Un,Pdfs,MF,kind)
%


%Fast. 
[M,V,LW,GS,GE]=PdfSt2Ma(Pdfs); Si=sqrt(V);

%Heavy. Modify Variances with Uncertainty. Estimate L
[k,nf]=size(Fe);
NG=length(LW); %Number of Gaussians

LPW=zeros(NG,nf);
fprintf('Gmm uncert: %s......\n',kind);
for n=1:nf
%for n=111
   fprintf('%d ',n); if mod(n,30)==1; fprintf('Of %d: \n',nf); end
    
   y=Fe(:,n);
   u=Un(:,n);     
   
   
   switch kind
       case {'MDGmm','MDNGmm'}
           TLPW=LW+LogMvnPdf1DataMD(y,u,M,Si,MF,kind);   
           
           
           
       case 'UnGmm'
           UV=VPlusM(u,V); %Heavy, Modify Variance with Uncertainty 
           TLPW=LW+LogMvnPdf1Data(y,M,UV);  %Temporal LogPr Weightted
           
           
   end
   
   LPW(:,n)=TLPW';  
end


%Fast. PseudoLL
PseudoLL=SumLogLik(LPW,GS,GE);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function PseudoLL=SumLogLik(LPW,GS,GE)
%Sum LogLik
NSt=length(GS);
[NG,nf]=size(LPW);
PseudoLL=zeros(NSt,nf);
for s=1:NSt    
    loglikes=LPW(GS(s):GE(s),:); 
    PseudoLL(s,:)=LogDot(loglikes,zeros(size(loglikes)));
end
