function PseudoLL=GmmLogLik(Fe,Pdfs)
%

fprintf('GmmLogLik\n');

NPdf=length(Pdfs);
[FL,nf]=size(Fe);
PseudoLL=zeros(NPdf,nf);
X=Fe';
X2=X.^2;

%fi=fopen('/home/jmorales/Gmm_NGaus.txt','w');

for s=1:NPdf  
    Gconsts=Pdfs{s}.Gconsts; %Contains mixed information of Weights, Means and Variances    
    Means_invvars=Pdfs{s}.Means_invvars;    
    Inv_vars=Pdfs{s}.Inv_vars;       
    loglikes=repmat(Gconsts,[nf,1])+ X*Means_invvars -  0.5*X2*Inv_vars; %1*ng       
    PseudoLL(s,:)=LogDot(loglikes',zeros(size(loglikes')));   
    
    %fprintf(fi,'%d %d\n',s,size(Gconsts,2));

end
%fclose(fi);


