function [CFey,Un,MD,HmmDir,P]=GetFeUnHmm(y,x,kind,P,do,bn)
%CFey: Contex Feature Noisy

switch kind
    
    case 'GmmMfccJuanKaldi'               
        
        HmmDir=['/home/jmorales/SpeechData/Models/ASR/HmmCHIME3CleanJuanFeat' '/' 'FinalMfccGmm'];        
        Feat=Sign2Feat(y,P,'Mfcc');                
        %In features (From FE)
        CmvnFeat=[do '/' bn 'CmvnFeat.ark']; 
        CmvnScp =[do '/' bn 'CmvnScp.txt'];
        Utt2Spk =[do '/' bn 'Utt2Spk.txt'];
        Spk2Utt =[do '/' bn 'Spk2Utt.txt'];
        FeatScp =[do '/' bn 'FeatScp.txt'];
        FeatArk =[do '/' bn 'Feat.ark'];
        Feat2 =[do '/' bn 'Feat2.txt'];
        %
        A.utt={bn}; A.feature={Feat};
        WrKaldFeat(A,FeatArk,FeatScp,P.KaldiRoot);
        %
        FeatScp2Cmvn(CmvnFeat,CmvnScp,Spk2Utt,Utt2Spk,FeatScp,P.KaldiRoot);
        %
        splice_feats        =[P.KaldiRoot '/featbin/splice-feats --verbose=0'];
        transform_feats     =[P.KaldiRoot '/featbin/transform-feats --verbose=0'];
        apply_cmvn          =[P.KaldiRoot '/featbin/apply-cmvn --verbose=0'];
        finalmat            =[HmmDir '/final.mat'];
        %       
        c=[apply_cmvn ' --utt2spk=ark:' Utt2Spk ' scp:' CmvnScp ' scp:' FeatScp ' ark:- | ' ...
        splice_feats ' --left-context=3 --right-context=3 ark:- ark:- | ' transform_feats ' ' finalmat ' ark:- ark,t:' Feat2];
        system(c);
        %
        [BN,CFey]=ReKaldTxtM(Feat2); CFey=CFey';
        %
        Un=randn(size(CFey));
        MD=Un<0.5;
    
    
    case 'GmmMfcc'
        
        
        
        
        P.NCH=23; P.NGa=30000;
        HmmDir=[P.HmmDir '/FinalMfccGmm' 'FL' num2str(P.NCH) 'NG' num2str(P.NGa)];         
        Cy=Sign2Feat(y,P,'Mfcc'); CFey=AppDeltas(Cy,2,2,'feat');    
        Cx=Sign2Feat(x,P,'Mfcc'); CFex=AppDeltas(Cx,2,2,'feat');                  
        Un=(CFey-CFex).^2;      
        MD=AppDeltas(YXHardMask((Cy),(Cx),3,exp(P.MF)),2,2,'mask');    
        
        
        
    case 'GmmFbank'
        P.NCH=5; P.NGa=70000;         
        Fby=Sign2Feat(y,P); CFey=AppDeltas(Fby,2,-1,'feat');    
        Fbx=Sign2Feat(x,P); CFex=AppDeltas(Fbx,2,-1,'feat');        
        Un=(CFey-CFex).^2;
        MD=AppDeltas(YXHardMask(exp(Fby),exp(Fbx),3,exp(P.MF)),2,-1,'mask');       
        HmmDir=[P.HmmDir '/FinalFbankGmm' 'FL' num2str(P.NCH) 'NG' num2str(P.NGa)];
        
    case 'DnnFbank'
        P.NCH=40; P.NGa=-1;         
        Fby=Sign2Feat(y,P); Fbx=Sign2Feat(x,P); 
        Un=(Fby-Fbx).^2;
        MD=YXHardMask(exp(Fby),exp(Fbx),3,exp(P.MF)); CFey=Fby;    
        HmmDir=[P.HmmDir '/FinalFbankDnn'];
        
        
end
