function acoustic_cost=TrSeq2AcCo(seq,StPr,models,npdfs,nf)
%From Transition id Sequence to Acoustic Cost using:
%StPr:      State Probabilities and models)
%models:    HMM models
%npdfs:     pdf number
%nf:        frame number




tid=seq;
tstate=models.TransitionModel.Id2state(tid);        %from transition-id to transition state
pdfs=models.TransitionModel.Triples(tstate,3);      %from transition state to pdf-id      
ix=sub2ind([npdfs,nf], pdfs', 1:nf); 
logliks=StPr(ix); %LogLikehoods
acoustic_cost=-sum(logliks); %acoustic cost
