function FeatGram=Sign2KaldFeatGram(y,fs,k,do,bn,P)
%Signal To Kaldi FeatureGram


%
AudF    =[do '/' bn '.wav'];
WavScp  =[do '/' bn 'WavScp.txt'];
FeatScp =[do '/' bn 'FeatScp.txt'];
Feat    =[do '/' bn 'Feat.ark'];

ArkAux    =[do '/' bn 'ArkAux.ark'];


%
audiowrite(AudF,y,fs);
fi=fopen(WavScp,'w');
fprintf(fi,'%s %s\n',bn,AudF);
fclose(fi);

%
copy_feats         =[P.KaldiRoot '/featbin/copy-feats --verbose=0'];
compute_mfcc_feats =[P.KaldiRoot '/featbin/compute-mfcc-feats --verbose=0']; 
compute_fbank_feats=[P.KaldiRoot '/featbin/compute-fbank-feats --verbose=0'];

Fun=[P.SMRoot '/JuanFE/Common/KaldMat/ReWr'];

switch k    
    case 'Mfcc'    
        config=[Fun '/mfcc.conf'];
        
        %' --channel=' channel
        c=[compute_mfcc_feats  ' --config=' config ' scp,p:' WavScp ' ark:- | ' copy_feats ' --compress=true ark:- ' ...
            ' ark,scp:' Feat ',' FeatScp]; 
        system(c);     
        

 
    case 'Fbank'           
        config=[Fun '/fbank.conf'];     
        
        

        c=[compute_fbank_feats ' --config=' config ' scp,p:' WavScp ' ark:- | ' copy_feats ' --compress=true ark:- ' ...
            ' ark,scp:' Feat ',' FeatScp];           
       system(c);


        
end

%
Y=ReKaldFeat(Feat,P.KaldiRoot);
FeatGram=Y.feature{1};


%Reshape to have Kaldi FeatGram the same number of frame as Juan
[FL,knf]=size(FeatGram);
nf=ceil((length(y)-P.FL)/P.FS);
if knf~=nf
    warning('Kaldi nf ~= Juan nf. Kaldi FeatGram reshaped.');
    A=FeatGram;
    FeatGram=zeros(FL,nf);
    mi=min(knf,nf);
    FeatGram(:,1:mi)=A(:,1:mi);    
end


%
delete(AudF,WavScp,FeatScp,Feat);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%




