function RecPerfDirKald(S,do,P)
%Recognition Performance of a Dir using Kaldi

if isfield(P,'ExpResDir')
    ResDir=P.ExpResDir; Id=P.JDirId;
else
    [p1,b1]=fileparts(do); [p2,b2]=fileparts(p1); [p3,b3]=fileparts(p2); 
    ResDir=[p3 '/Res']; Id='xx';
end


[x,x,x]=mkdir(ResDir);




%Id from WerF
WerF      = [ResDir '/' Id '_Wer.txt']; %WerF
ETrans      =[ResDir '/' Id '_ETrans.txt']; %Estimated Transcriptions
TmpTTrans   =[ResDir '/' Id '_TmpTTrans.txt']; %Temporal True Transcriptions

%True Trans 
%For Vad
% OTTran=[do '/TmpOTTran.trn_all']; %Original True Transcriptions
% CrOTTran(OTTran,P.TransDir,S.BN,S.OrtT);            

C=strsplit(P.SpCond2,'_'); bn=[C{1} '_' C{3}];
OTTran=[P.TransDir '/' bn '.trn_all']; %Original True Transcriptions







%OTTran to TempTTran
c=['cat ' OTTran ' | sed ''s:<NOISE>::g'' | sed ''s:<SPOKEN_NOISE>::g'' > ' TmpTTrans];
system(c);



%TempETran2 to WerF
WrDictF(ETrans,S.BN,S.OrtT);




c=[P.KaldiRoot '/bin/compute-wer --text --mode=present ark:' ETrans ' ark:' TmpTTrans ' > ' WerF];


fprintf('------------------------------WerF (%s) of %s --------------------------------\n',datestr(clock),do);
system([c '; cat ' WerF]);
fprintf('------------------------------------------------------------------------------\n');
delete(TmpTTrans);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function TTrans=CrOTTran(OTTran,TransDir,BN,OrtT)
%
%
AllMat=[TransDir '/' 'AllTrn_all.mat'];
if ~exist(AllMat,'file')
    [Key,Val]=ReDictF([TransDir '/' 'All' '.trn_all']);
    save(AllMat,'Key','Val');
end
load(AllMat)
%
[TTrans]=Key2ValDict(BN,Key,Val,0);
%
WrDictF(OTTran,BN,TTrans);


