function [Lat,Trans]=Lik2LattTrans(PseudoLL,HmmDir,do,bn,P)
%Likegram To Latt and Transcription


%Check PseudoLL Inf or NaN
a=PseudoLL; i=(isinf(a)|isnan(a)); if sum(i(:))>0; a(i)=0; PseudoLL=a; warning('Detected Inf or NaN'); end;



%Common
WList             = [P.RecDataDir '/WoWList.txt'];


%New version (without noisy Lat)
loglikes_rspecifier     =[do '/' bn 'LokLik.txt'];
LatGz                   =[do '/' bn 'LatGz.ark'];

%
latgen_faster_mapped=[P.KaldiRoot '/bin/latgen-faster-mapped --verbose=0'];


%Model
finalmdl            =[HmmDir '/final.mdl'];
if ~exist(finalmdl,'file');
    fprintf('WARNING in LikGram2Latt: probably you are with GMM and not DNN. Choosen final.alimdl instead of final.mdl\n');
    finalmdl        =[HmmDir '/final.alimdl'];
end
HCLG                =[HmmDir '/HCLG.fst'];

%
PseudoLL=PseudoLL'; %Kaldi works as nf*nst 
WrKaldTxtM(loglikes_rspecifier,bn,PseudoLL)


%Command
%--acoustic-scale=0.10 (default) [0.083 1.1111]
lattice_wspecifier  =['ark:|gzip -c > ' LatGz];
c=[latgen_faster_mapped ' --min-active=200 --max-active=7000 --max-mem=50000000 --beam=18.0 --lattice-beam=10.0 --acoustic-scale=0.10 --allow-partial=true' ...
   ' --word-symbol-table=' WList ...
   ' ' finalmdl ' ' HCLG ' ark,t:' loglikes_rspecifier ' "' lattice_wspecifier '"']; 
system(c);


%
Trans=LatGz2Trans(LatGz,do,bn,P);
Lat=ReKaldLatt(LatGz,WList,P.KaldiRoot,P.KaldiTrunkRoot);


%
delete(loglikes_rspecifier,LatGz);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%











