function Lat2ULatNBest(UncLatGz,LatGz,HmmDir,models,WList,do,TeK,NumNBest,P)
%Lattice To Uncertainty Lattice based on NBest




%
TempNBestGz     =[do '/' TeK 'NBest.gz'];
TempUncNBestGz  =[do '/' TeK 'UncNBest.gz'];
MatNbest        =[do '/' TeK 'MatNbest.mat'];


%
lattice_to_nbest=[P.KaldiRoot '/latbin/lattice-to-nbest'];
nbest_to_lattice=[P.KaldiRoot '/latbin/nbest-to-lattice'];

%Heavy. It depends on NumNBest

fprintf('lattice_to_nbest....');
c=[lattice_to_nbest '  --acoustic-scale=0.10 --n=' NumNBest ' ark:"gunzip -c ' LatGz ' |" ark:"|gzip -c > ' TempNBestGz '"'];
system(c);  fprintf('done\n');


%
fprintf('readkaldinbests....');
nbest=readkaldinbests(TempNBestGz,WList,P.KaldiRoot,P.KaldiTrunkRoot); %2.5 sec
fprintf('done\n');
save(MatNbest,'nbest');



nbestmod=ModAcCoNBest(HmmDir,nbest,models,do,TeK,P); %0.04s
%nbestmod=nbest;


fprintf('writekaldinbests....');
writekaldinbests(nbestmod,TempUncNBestGz,WList,P.KaldiRoot,P.KaldiTrunkRoot); %2.5 sec
fprintf('done\n');

%Write Unc Lattice
c=[nbest_to_lattice '  ark:"gunzip -c ' TempUncNBestGz ' |" ark:"|gzip -c > ' UncLatGz '"'];
system(c);

%
delete(TempNBestGz,TempUncNBestGz);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function NBest=ModAcCoNBest(HmmDir,ONBest,models,do,TeK,P)
%Modify the Acoustic Cost of NBest (using States Probabilities)


NBest=ONBest;
nutt=length(ONBest.utt);

for u=1:nutt              
    LL=VadPseudoLL(HmmDir,do,TeK,ONBest.utt{u},models,P);       
    NBest.nbest{u}=ModAcCoNBest1Utt(ONBest.nbest{u},LL,models);    
end


function nbest=ModAcCoNBest1Utt(nbesto,StPr,models)
%Modify Accoustic Cost in NBest for 1 Utt
% nbest.
% words: 'IN A STATEMENT R. L. R. SAID THE BROKERAGE UNIT GENERATED SUBSTANTIALLY ALL OF ITS CURRENT NAME'
%        graph_cost: 142.5918
%     acoustic_cost: -1.3898e+04
%               seq: [1x607 uint16]

nbest=nbesto;
nb=length(nbest);
[npdfs,nf]=size(StPr);

for n=1:nb    
    ac=TrSeq2AcCo(nbest{n}.seq,StPr,models,npdfs,nf);   
    nbest{n}.acoustic_cost=ac;    

end







