function [Lat,Trans]=KaldFeatGram2Lat(Feat,k,HmmDir,do,bn,P)
%Features To Lattice. 
%Compared to Feat2LikGram this doesnt produce as output the likelihoods
%


%In features (From FE)
CmvnFeat=[do '/' bn 'CmvnFeat.ark']; 
CmvnScp =[do '/' bn 'CmvnScp.txt'];
Utt2Spk =[do '/' bn 'Utt2Spk.txt'];
Spk2Utt =[do '/' bn 'Spk2Utt.txt'];
FeatScp =[do '/' bn 'FeatScp.txt'];
FeatArk =[do '/' bn 'Feat.ark'];
LatGz   =[do '/' bn 'LatGz.ark'];
UncLatGz  =[do '/' bn 'UncLatGz.ark'];

%
A.utt={bn}; A.feature={Feat};
WrKaldFeat(A,FeatArk,FeatScp,P.KaldiRoot);

%
FeatScp2Cmvn(CmvnFeat,CmvnScp,Spk2Utt,Utt2Spk,FeatScp,P.KaldiRoot);


%Common
TestDir           =[P.RecRoot '/RecStages/TestGen/TestDir/' P.SDBase];
WList             =[TestDir '/' P.RecPref 'WList.txt']; 

%
switch k
    case 'Gmm'
        fprintf('KaldiGmm...\n')
        GmmDec(FeatScp,Utt2Spk,CmvnScp,LatGz,HmmDir,WList,P);
    case 'Dnn'
        fprintf('KaldiDnn...\n')
        DnnDec(FeatScp,LatGz,HmmDir,WList,P);        
end


%
Trans=LatGz2Trans(LatGz,do,bn,P);
Lat=ReKaldLatt(LatGz,WList,P.KaldiRoot,P.KaldiTrunkRoot);


%
delete(CmvnFeat,CmvnScp,Utt2Spk,Spk2Utt,FeatScp,FeatArk,LatGz,UncLatGz);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function GmmDec(FeatScp,Utt2Spk,CmvnScp,LatGz,HmmDir,WList,P)
%
gmm_latgen_faster   =[P.KaldiRoot '/gmmbin/gmm-latgen-faster --verbose=0'];
splice_feats        =[P.KaldiRoot '/featbin/splice-feats --verbose=0'];
transform_feats     =[P.KaldiRoot '/featbin/transform-feats --verbose=0'];
apply_cmvn          =[P.KaldiRoot '/featbin/apply-cmvn --verbose=0'];
max_active='2000'; beam='10.0'; lattice_beam='6.0'; acoustic_scale='0.083333'; allow_partial='true'; 
%Input Model
finalmat            =[HmmDir '/final.mat'];%[AsrRoot '/exp/tri3b_tr05_orig_clean/final.mat']
model               =[HmmDir '/final.alimdl']; %'/exp/tri3b_tr05_orig_clean/final.alimdl'
graphdirHCLG        =[HmmDir '/HCLG.fst']; %[AsrRoot '/exp/tri3b_tr05_orig_clean/graph_tgpr_5k/HCLG.fst'] %Model
%Command
features_rspecifier =['ark,s,cs:' apply_cmvn ' --utt2spk=ark:' Utt2Spk ' scp:' CmvnScp ' scp:' FeatScp ' ark:- | ' ...
    splice_feats ' --left-context=3 --right-context=3 ark:- ark:- | ' transform_feats ' ' finalmat ' ark:- ark:- |'];
lattice_wspecifier  =['ark:|gzip -c > ' LatGz];
%
c=[gmm_latgen_faster ' --max-active=' max_active ' --beam=' beam ' --lattice-beam=' lattice_beam ...
    ' --acoustic-scale=' acoustic_scale ' --allow-partial=' allow_partial ' --word-symbol-table=' WList ...
    ' ' model ' ' graphdirHCLG '  "' features_rspecifier '" "' lattice_wspecifier '"'];
system(c);



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function DnnDec(featscp,LatGz,HmmDir,WList,P)
%
nnet_forward        =[P.KaldiRoot '/nnetbin/nnet-forward --verbose=0']; %Brno and Microsoft, Karel Vesely
copy_feats          =[P.KaldiRoot '/featbin/copy-feats --verbose=0'];
latgen_faster_mapped=[P.KaldiRoot '/bin/latgen-faster-mapped --verbose=0'];
%    3 //         Copyright 2009-2012  Microsoft Corporation, Karel Vesely
%     4 //                2013  Johns Hopkins University (author: Daniel Povey)
%     5 //                2014  Guoguo Chen

%Model
feature_transform   =[HmmDir '/final.feature_transform']; %generated at training
class_frame_counts  =[HmmDir '/ali_train_pdf.counts'] ;
nnet                =[HmmDir '/final.nnet'];
finalmdl            =[HmmDir '/final.mdl'];
HCLG                =[HmmDir '/HCLG.fst'];

%Command
feat=['ark,s,cs:' copy_feats ' scp:' featscp ' ark:- |'];
lattice_wspecifier  =['ark:|gzip -c > ' LatGz];

c=[nnet_forward ' --feature-transform=' feature_transform ' --no-softmax=true --class-frame-counts=' class_frame_counts ... 
   ' --use-gpu=no ' nnet ' "' feat '" ' ...
   'ark:- | ' latgen_faster_mapped ' --min-active=200 --max-active=7000 --max-mem=50000000 --beam=18.0 --lattice-beam=10.0 --acoustic-scale=0.10 --allow-partial=true' ...
   ' --word-symbol-table=' WList ...
   ' ' finalmdl ' ' HCLG ' ark:- "' lattice_wspecifier '"'];  
system(c);








