function CFey=Juan2KaldFeat(Feat,kind,HmmDir,do,bn,P,St)
%

%Future: not depend on database
if ~isempty(strfind(P.SpCond2,'tr05_'))
    St='Tr';
elseif ~isempty(strfind(P.SpCond2,'dt05_'))
    St='Dev';
else
    St='Te';
end



%In features (From FE)
CmvnFeat=[do '/Tmp' bn 'CmvnFeat.ark'];
CmvnScp =[do '/Tmp' bn 'CmvnScp.txt'];
Utt2Spk =[do '/Tmp' bn 'Utt2Spk.txt'];
Spk2Utt =[do '/Tmp' bn 'Spk2Utt.txt'];
FeatScp =[do '/Tmp' bn 'FeatScp.txt'];
FeatArk =[do '/Tmp' bn 'Feat.ark'];
Feat2 =[do '/Tmp' bn 'Feat2.txt'];
%
A.utt={bn}; A.feature={Feat};
WrKaldFeat(A,FeatArk,FeatScp,P.KaldiRoot);
%
FeatScp2Cmvn(CmvnFeat,CmvnScp,Spk2Utt,Utt2Spk,FeatScp,P.KaldiRoot);
%
add_deltas          =[P.KaldiRoot '/featbin/add-deltas'];
splice_feats        =[P.KaldiRoot '/featbin/splice-feats --verbose=0'];
transform_feats     =[P.KaldiRoot '/featbin/transform-feats --verbose=0'];
apply_cmvn          =[P.KaldiRoot '/featbin/apply-cmvn --verbose=0'];
finalmat            =[HmmDir '/final.mat'];

switch kind      
    
    case 'CepD'
            c=[apply_cmvn ' --utt2spk=ark:' Utt2Spk ' scp:' CmvnScp ' scp:' FeatScp ' ark:- | ' add_deltas ' ark:- ark,t:' Feat2];

    
    case 'Lda'
        
        c=[apply_cmvn ' --utt2spk=ark:' Utt2Spk ' scp:' CmvnScp ' scp:' FeatScp ' ark:- | ' ...
            splice_feats ' --left-context=3 --right-context=3 ark:- ark:- | ' transform_feats ' ' finalmat ' ark:- ark,t:' Feat2];
        
        
    case 'Fmllr'          
        Trans=[HmmDir '/' St 'trans.1'];  %Fmllr transformation      
        c=[apply_cmvn ' --utt2spk=ark:' Utt2Spk ' scp:' CmvnScp ' scp:' FeatScp ' ark:- | ' ...
           splice_feats ' --left-context=3 --right-context=3 ark:- ark:- | ' transform_feats ' ' finalmat ' ark:- ark:- | ' ...
           transform_feats ' --utt2spk=ark:' Utt2Spk ' ark:' Trans ' ark:- ark,t:' Feat2];               
        
end

system(c);
[BN,CFey]=ReKaldTxtM(Feat2); CFey=CFey';

%I should delete many tmp files
delete(CmvnFeat,CmvnScp,Utt2Spk,Spk2Utt,FeatScp,FeatArk,Feat2)


