function [LPreA,Posteriors]=nnet_forward(nnet,features)
% [LPreA,Posteriors]=nnet_forward(nnet,features) applies the 
% feed-forward path of the neural network and returns the pre-activation (LPreA)
% of the softmax layer and the output posteriors (Posteriors).
% Input arguments:
% nnet --> cell array containing neural network parameters. 
% features --> Feature matrix
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%                              
% Written by Ahmed Hussen Abdelaziz and Shinji Watanabe  
% Copyright(c) MERL 2014                                  
% Permission is granted for anyone to copy, use, or modify 
% this program for purposes of research or education. This program 
% is distributed without any warranty express or implied.   
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%








fprintf('Doing nnet_forward......\n');

tmpfeat=features;


for i=1:2:(numel(nnet)-2)
    % Pre-activations
    z=nnet{i}*tmpfeat+repmat(nnet{i+1}',[1 size(features,2)]);
    
    
    % Sigmoid Function
    h=sigmoid(z);   
    
    
    tmpfeat=h;
end
% Pre-activation of the softmax layer
LPreA=nnet{end-1}*tmpfeat+repmat(nnet{end}',[1 size(features,2)]);
% Apply the softmax function
Posteriors=softmax(LPreA);

