function [feats]=nnet_applyContext(featsSingle,conf,k)
% feats=nnet_applyContext(featsSingle,conf) appends n frames before and
% after the current frame, rescales, and shifts them. 
% Input arguments:
% featsSingle --> D*T matrix includes T D-dimensional feature vectors. 
% conf --> cell array from final.feature_transform, where 
%          conf{1} includes the number of frames n that should be appended
%          conf{2} shift factors
%          conf{3} rescale factors
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%                              
% Written by Ahmed Hussen Abdelaziz and Shinji Watanabe  
% Copyright(c) MERL 2014                                  
% Permission is granted for anyone to copy, use, or modify 
% this program for purposes of research or education. This program 
% is distributed without any warranty express or implied.   
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%Check if we have a MD binary mask
v=unique(featsSingle);
if strcmp(k,'unc')&&(length(v)<3);
    k='bmask';
end

% %conf{1}=[    -5    -4    -3    -2    -1     0     1     2     3     4     5]
% HWL=max(conf{1}); %Half widow lenght
% 
% % Find matrix dimension 
% [D,T]=size(featsSingle);
% 
% % Initialize the output matrix
% feats=zeros(length(conf{1})*D,T);
% featsSingle2=[repmat(featsSingle(:,1),[1,HWL]) featsSingle repmat(featsSingle(:,end),[1,HWL])];
% 
% % Append the context frames
% for i=1:T % conf{1}=10; x=[xi; xi+1; ....; xi+10]
%     start=i;
%     ende=i+length(conf{1})-1;    
%     feats(:,i)=reshape(featsSingle2(:,start:ende),[D*length(conf{1}),1]);
% end


feats=AppContext(featsSingle,max(conf{1}));

%The centrum of feats is equivalent to featsSingle (there is bias in time)
%feats(5*40+1:6*40,:)=featsSingle

[D,T]=size(featsSingle);
switch k
    case 'feat' %Fe=(x+a).*b
        % Shift the features       
        feats=feats+repmat(conf{2}',[1,T]);
        % rescale the features
        feats=feats.*repmat(conf{3}',[1,T]);     
        
    case 'unc' %Un=u.*b^2
        feats=repmat(conf{3}',[1,T]).*feats.*repmat(conf{3}',[1,T]);

    case 'bmask' 
        %everything done with the append
        
        
end


