function PseudoLL=Unc2LikGramDnn(feats,uncert,HmmDir,UnK,P)
%Uncertainty To Likelihood Gram for Dnn
%feats and uncert:  feature and uncertainty with context (not already normalized)
%Y and U:           feature and uncertainty WITHOUT context (not already normalized)
%HmmDir:            Hmm Directory where the nnet, ali_train_pdf.counts and final.feature_transform
%UnK:               Uncertainty Kind of propagation. String where ('_' is the options separator) of the type:
%                   'Dnn' (Standard, no uncertainty used)
%                   'En_OU2' (Entire with OU2), 
%                   'IS_OU2' (Important Sampling with OU2), 
%                   .....(see switch below).
%                   Remember:
%                   'OU1': Mean of LPreActivations: LPostF=MeVa3DM(LPreA3D,w); (L because preactivations are in log-domain)
%                   'OU2': Log of Mean of Posteriors: log(MeVa3DM(Post3D,w)); %Best results!!!
%                   'OU3': Mean of log of Posteriors:   LPostF=MeVa3DM(log(Post3D),w); 
%P:                 Parameter structure (KaldiRoot,...)
%
%PseudoLL: Pseudo Log Likelihood


%Read Kaldi information
nnet=ReSaKaldNNet([HmmDir '/final.nnet'],P.KaldiRoot); % DNN
LPrior=ReKaldPriors([HmmDir '/ali_train_pdf.counts']); % Log Priors


%
C=strsplit(UnK,'_'); 
switch C{1}
    case 'Sta' %Standard, no uncertainty used
        [LPreA,xx]=nnet_forward(nnet,feats); %LPreA is the last layer or preactivation layer (before softmax) is a kind of Log of Posterior        
   case 'Un' %Entire
        [LPreA]=nnet_EntireUT_propagate(nnet,feats,uncert,-1,'En','OU2',P);        
   case 'MD' %Missing Data
        [LPreA]=nnet_EntireUT_propagate(nnet,feats,uncert,-1,'MD','OU2',P);        

end


%Pseudo Log Likelihood (LogPreActivations - LogPriors)
PseudoLL=LPreA-repmat(LPrior,[1,size(LPreA,2)]); 

% subplot(211), jimagesc(feats)
% subplot(212), jimagesc(PseudoLL)
% pause

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [LPostF]=nnet_EntireUT_propagate(nnet,Y,U,config,WK,OUK,P)
%
[X3D,w]=GenMCSamp(Y,U,WK,P); %Generate samples and corresponding weigths


[LPreA3D,Post3D]=X3D2ContPostDnn(X3D,config,nnet); %Apply context and to samples and generate corresponding posteiors samples

LPostF=Av3DLPost(LPreA3D,Post3D,w,OUK); %Average the posteriors






