function PseudoLL=Unc2LikGramDnn(feats,uncert,Y,U,HmmDir,UnK,P)
%Uncertainty To Likelihood Gram for Dnn
%feats and uncert:  feature and uncertainty with context (not already normalized)
%Y and U:           feature and uncertainty WITHOUT context (not already normalized)
%HmmDir:            Hmm Directory where the nnet, ali_train_pdf.counts and final.feature_transform
%UnK:               Uncertainty Kind of propagation. String where ('_' is the options separator) of the type:
%                   'Dnn' (Standard, no uncertainty used)
%                   'En_OU2' (Entire with OU2), 
%                   'IS_OU2' (Important Sampling with OU2), 
%                   .....(see switch below).
%                   Remember:
%                   'OU1': Mean of LPreActivations: LPostF=MeVa3DM(LPreA3D,w); (L because preactivations are in log-domain)
%                   'OU2': Log of Mean of Posteriors: log(MeVa3DM(Post3D,w)); %Best results!!!
%                   'OU3': Mean of log of Posteriors:   LPostF=MeVa3DM(log(Post3D),w); 
%P:                 Parameter structure (KaldiRoot,...)
%
%PseudoLL: Pseudo Log Likelihood


%Read Kaldi information
nnet=ReSaKaldNNet([HmmDir '/final.nnet'],P.KaldiRoot); % DNN
LPrior=ReKaldPriors([HmmDir '/ali_train_pdf.counts']); % Log Priors
config=ReKaldFeatTr([HmmDir '/final.feature_transform']); % Info of feature contex

%
C=strsplit(UnK,'_'); 
switch C{1}
    case {'Dnn', 'Pseudo'} %Standard, no uncertainty used
        [LPreA,xx]=nnet_forward(nnet,feats); %LPreA is the last layer or preactivation layer (before softmax) is a kind of Log of Posterior        
    case 'PIE_OU1' %PIE 
        [LPreA, xx]=nnet_PIE_propagate(nnet,feats,uncert);
    case 'LayerUT_OU1' %Uncested
        [LPreA, xx]=nnet_UT_propagate(nnet,feats,uncert);       
    case 'En' %Entire
        [LPreA]=nnet_EntireUT_propagate(nnet,Y,U,config,'En',C{2},P);        
    case 'MC'  %Monte Carlo
        [LPreA]=nnet_EntireUT_propagate(nnet,Y,U,config,'MC',C{2},P);       
    case 'MD' %Missing Data
        [LPreA]=nnet_EntireUT_propagate(nnet,Y,U,config,'MD',C{2},P);        
    case 'IS'  %Important Sampling
        [LPreA]=nnet_EntireUT_propagate(nnet,Y,U,config,'IS',C{2},P);
end


%Pseudo Log Likelihood (LogPreActivations - LogPriors)
PseudoLL=LPreA-repmat(LPrior,[1,size(LPreA,2)]); 



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [LPostF]=nnet_EntireUT_propagate(nnet,Y,U,config,WK,OUK,P)
%
[X3D,w]=GenMCSamp(Y,U,WK,P); %Generate samples and corresponding weigths

[LPreA3D,Post3D]=X3D2ContPostDnn(X3D,config,nnet); %Apply context and to samples and generate corresponding posteiors samples

LPostF=Av3DLPost(LPreA3D,Post3D,w,OUK); %Average the posteriors














