function TrRec(do,P)
%Train Recognizer
%To run on GPU: 
%1) FETr on lapto.
%2) Copy AsrEngine and result of FETr to GPU
%3) Open Matlab15 (not 13, see InitGPU.sh) and run

%
HmmRoot=P.ExpHmmDir;
FeatDir=P.FeatDir;

%Code
wsj0_data   =[P.SpeechRoot '/CHIME3_All/CHiME3/data/WSJ0'];

TrKaldDir    =[P.RecRoot '/TrainKaldi'];
LMPrepDir   =[TrKaldDir '/LMPrep'];
GmmDir      =[TrKaldDir '/GmmTr'];
DnnDir      =[TrKaldDir '/DnnTr'];

%Res
InfoDir         = [HmmRoot '/Info'];
LMResMDir   =[HmmRoot '/LM/MDir'];
LMRes       =[HmmRoot '/LM'];
%GmmRes      =[HmmRoot '/Gmm'];
GmmRes      =[P.ResRoot '/Gmm']; %FUTURE
DnnRes      =[HmmRoot '/Dnn'];
SpnRes      =[HmmRoot '/Spn'];



%Param
%FeatType    ='Kald'; %User or Kald (User sometimes doesnt finish (depending on small randon set selected))
FeatType    ='User'; %User or Kald (User sometimes doesnt finish (depending on small randon set selected))
TotGDelt    ='10000'; %default=10000
TotGLdaSat  ='15000';  %default=15000; 
Param       =['"' TrKaldDir ' ' P.KaldiTrunkRoot ' ' FeatType ' ' TotGDelt ' ' TotGLdaSat  '"'];



%Feature Info (heavy)
%   GenInfo([InfoDir '/MfccTrInfoDir'],FeatDir,    [P.TrDir(1:4) ],'Cx',P);
%   GenInfo([InfoDir '/FbankTrInfoDir'],FeatDir,  [P.TrDir(1:4) ],'Fbx',P);
%   GenInfo([InfoDir '/MfccDevInfoDir'],FeatDir,  [P.TrDir(5:8) ],'Cx',P);
%   GenInfo([InfoDir '/FbankDevInfoDir'],FeatDir,[P.TrDir(5:8) ],'Fbx',P);
%    GenInfo([InfoDir '/MfccTeInfoDir'],FeatDir,    [P.TrDir(9:12)],'Cx',P);
%    GenInfo([InfoDir '/FbankTeInfoDir'],FeatDir, [P.TrDir(9:12)],'Fbx',P);
%    213
%   pause



%Language Model
%
%CopyWSJ04LM([P.SpeechRoot '/CHIME3_All/OrigCHiME3/data/WSJ0'],[P.SpeechRoot '/CHIME3_All/CHiME3/data/WSJ0']);
%c=[TrKaldDir '/LMTr.sh ' LMPrepDir ' ' wsj0_data ' ' LMResMDir ' ' Param]; system(c);


%GMMs
%CopyLM4GMM(LMResMDir,LMRes); %If previously I execute Language Model part


%c=[TrKaldDir '/GmmTr.sh ' GmmDir ' ' LMPrepDir ' ' LMRes ' ' InfoDir ' ' GmmRes ' ' Param]; system(c)

%Create Graphs, Ali and Fmllr transformations, and Copy final result
%MkGraphCpFin(TrKaldDir,LMRes,GmmRes,P)
% AliFmllrT(TrKaldDir,InfoDir,'Tr',P);
% AliFmllrT(TrKaldDir,InfoDir,'Dev',P);
% AliFmllrT(TrKaldDir,InfoDir,'Te',P);
% pause


switch P.ExOpt.SpnTrK{1}
    case 'Dnn' 

        %
        CopyLM4GMM([P.SpeechRoot '/CHIME3_All/LM'],LMRes); %If LM (results of LM part) is already in SpeechRoot
                
        
        
        %Check FL, 
        fn=[FeatDir '/' P.TrDir{1} '/011_011C0203_BUS.Fbx'];
        M=ReadHTKF(fn,0,0);   FL=size(M,1);
                
        
        
        %create NoTransf in GmmRes
        [x,x,x]=mkdir(GmmRes);
        conf{1}=0;   conf{2}=zeros(FL,1);  conf{3}=ones(FL,1);
        WrKaldFeatTr([GmmRes '/final_NoTransf.feature_transform'],conf);
        
        
        
        %copy Tree in GmmRes
        %To do (now manually)
        
        %DNNs
        c=[TrKaldDir '/DnnTr.sh ' DnnDir ' ' LMPrepDir ' ' LMRes ' ' GmmRes ' ' SpnRes ' ' InfoDir ' ' DnnRes ' ' Param]; system(c);
        
        
    otherwise
        %SPNs
        SpnTr(SpnRes,GmmRes,P);
end






