function [PTr,PDev,FTr, FDev,Info]=TrDevNormData(GParDir,ModDir,ModBNN,AsPTr,AsPDev,AsFTr,AsFDev,MvnK,PermK,MixTrDevSamp)
%Normalize features and labels. Delete Dev labels not covered by Train

%




%Read and shufle data
[Tr,Dev,NS]=TrDevMat2FePoPh([ModDir '/Tr/Tr' ModBNN '.mat'],[ModDir '/Dev/Dev' ModBNN '.mat'],AsFTr,AsFDev,PermK,MixTrDevSamp);


%Normalize Tr and Dev X (features)
fprintf('Normalizing with: %s\n',MvnK)
TrX=NormFeUn(Tr.Fe,GParDir,'feat',MvnK,['Tr' ModBNN]);
DevX=NormFeUn(Dev.Fe,GParDir,'feat',MvnK,['Tr' ModBNN]);


%Read Labels (Po or Ph)
TrY=Tr.ModO; DevY=Dev.ModO;       
%TrY=Tr.Ph; DevY=Dev.Ph; UsedLab='Ph';

%
[FTr, FDev, Lab,Out]=NormLabChCover(TrX,TrY,DevX,DevY);


%
Info.NS=NS;
Info.LabOutDict=[Lab;Out];
Info.MvnK=MvnK;

%
[PTr,PDev]=Fi2PDTrDevData(FTr,FDev,AsPTr,AsPDev);



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [PTr,PDev]=Fi2PDTrDevData(FTr,FDev,AsPTr,AsPDev)
%Fine To PoonDomingos Dev Tr Data. Ensure all labels are included with LastUniIdx
AsPTr=min(AsPTr,size(FTr.X,2));
j=LastUniIdx(FTr.Y);
PTr.X=[FTr.X(:,1:AsPTr) FTr.X(:,j)];
PTr.Y=[FTr.Y(:,1:AsPTr) FTr.Y(:,j)];
%
AsPDev=min(AsPDev,size(FDev.X,2));
j=LastUniIdx(FDev.Y);
PDev.X=[FDev.X(:,1:AsPDev) FDev.X(:,j)];
PDev.Y=[FDev.Y(:,1:AsPDev) FDev.Y(:,j)];

function j=LastUniIdx(Y)
%
UY=unique(Y);
l=length(UY); 
j=zeros(1,l); 
p=jrandperm(l,l,'rc'); %rand to avoid labels apears in order 
for i=1:l
    j(p(i))=find(Y==UY(i),1,'last'); 
end


function [FTr, FDev, Lab, Out]=NormLabChCover(TrX,TrY,DevX,DevY)
%Check Cover (In case Dev.Y bigger than Tr.Y)
%Cover
UTrY=unique(TrY);
UDevY=unique(DevY);
ExDevY=setdiff(union(UTrY,UDevY),UTrY); %Exclusive DevY
for i=1:length(ExDevY)   
    j=find(DevY==ExDevY(i));    
    DevY(j)=[];
    DevX(:,j)=[];   
    warning('Removed label %d from Dev because is not in Tr',ExDevY(i));    
end
%Normalization
Lab=UTrY; 
Out=0:length(Lab)-1;
[FTr.Y]=Key2ValDictA(TrY,Lab,Out);
[FDev.Y]=Key2ValDictA(DevY,Lab,Out);

%
FTr.X=TrX; 
FDev.X=DevX; 









