function TrDevModSamp(TrDevModDir,TrAli,DevAli,Mdl,P,TrModK)
%Generate the Train/Development Model Samples for training by using the alignements
%Organize the samples for every model or pdf (using posteriors of
%alignement)
%
%TrDevModDir: Train Dev
%TrAli, DevAli: Training, Dev alignement
%Mdl: Hmm file .mdl
%P: Parameter structure
%TrModK: Training Model Kind

DevDir=[TrDevModDir '/Dev'];
TrDir=[TrDevModDir '/Tr'];

SaveKald2MatAli(DevDir,'Dev',DevAli,Mdl,P,P.FeatDir,P.TrDir(5:8),'Fbx',TrModK);
SaveKald2MatAli(TrDir,'Tr',TrAli,Mdl,P,P.FeatDir,P.TrDir(1:4),'Fbx',TrModK);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function SaveKald2MatAli(do,bn,AliGz,Mdl,P,FeatDir,Fo,Ext,TrModK)
%Save Kaldi To Matlab Alignement. Create a .mat per SPN for Dev or Tr
%Phonemes do not take big space so we include them.
%FeTran: '0' means not transformation. Otherwise pass the config file.

%Read Align Gz
[ABN,AModC,AModOC,APoC,APhC]=AliGz2AlignDic(AliGz,Mdl,do,bn,P,TrModK);
%save('./p.mat','ABN','AModC','AModOC','APoC','APhC')
%load('./p.mat')

%To check Po-Ph in save
models  = ReSaKaldGmm(Mdl,1,P.KaldiRoot); 

%Read BN and Feat from Htk files
[BN,FeC]=ReBnFeat(FeatDir,Fo,Ext);



%Put Features (BN, FeC) in Alignement order (ABN, AModC,...) depending on 
%length(BN) and length(ABN)
%Remind when we are not using all the database (in ABN)
%7138 Tr files official simu files
BNL=length(BN);
ABNL=length(ABN);
if ABNL>=BNL    
    if ABNL~=BNL
        warning('Not using all the Tr files')   
    end
    [ModC,k]=Key2ValDict(BN,ABN,AModC,1);
    ModOC=AModOC(k);
    PoC=APoC(k);
    PhC=APhC(k);
elseif ABNL<BNL 
    warning('There are more Tr files than in the alignement information')
    [FeC,k]=Key2ValDict(ABN,BN,FeC,1);
    ModC=AModC;
    ModOC=AModOC;
    PoC=APoC;
    PhC=APhC;    
end




%Organize data for the diferent models
[AllMod]=Cell2M(ModC); 
UMod=unique(AllMod); %Unique models
nm=length(UMod); 

  
for i=1:nm        
    Mod=UMod{i};    
    fprintf('Organize data for model: %s (%d/%d)\n',Mod,i,nm);   
    
    %Find Idx of label for all cells
    KC=FindCellV(ModC,Mod);
        
    %Feat
    FeatC=ExtrCellM(FeC,KC);    
    [Feat]=Cell2M(FeatC);      
   
    %ModOC
    ModelOC=ExtrCellM(ModOC,KC);    
    [ModO]=Cell2M(ModelOC);    
        
    %Post
    PostC=ExtrCellM(PoC,KC);    
    [Post]=Cell2M(PostC);             
    
    %Ph
    PhoneC=ExtrCellM(PhC,KC);    
    [Phone]=Cell2M(PhoneC);      
    
    %Save
    MatF=[do '/' bn Mod '.mat'];    
    SaChFePoPh(MatF,Feat,ModO,Post,Phone,models);   

end



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [YBN,YC]=ReBnFeat(FeatDir,Fo,Ext)
%
l=length(Fo);
CList=[];
for i=1:l
    CList=[CList; LsBn12Ext([FeatDir '/' Fo{i}],'','*',Ext)];
end
l=length(CList);
YBN=cell(l,1);
YC=cell(l,1);
fprintf('Reading of %d:\n',l);
for i=1:l    
    fprintf('%d ',i); if mod(i,30)==0; fprintf('\n'); end    
    [pn,bn]=fileparts(CList{i});
    YBN{i}=bn;
    YC{i}=ReadHTKF(CList{i},0,0);    
end
fprintf('\n')


function EC=ExtrCellM(C,KC)
%Extract from Cell of Matrix
l=length(C);
EC=cell(size(C));
for i=1:l
    A=C{i};
    EC{i}=A(:,KC{i});
end


function KC=FindCellV(C,label)
%Find in Cell Vectors
l=length(C);
KC=cell(size(C));
for i=1:l
    a=C{i};
    %KC{i}=find(a==label);
    KC{i}=strcmp(a,label); % single line engine    
end



