function [Me,Std,Mi,Ma,I]=MeStdFList(MatC)
%Mean and Std (not Var!) of a FList

[Me]=CompExpFList(MatC,[]);
[V,I]=CompExpFList(MatC,Me);

Std=sqrt(V); %Do not forget the sqrt
Mi=min(I.Mi,[],2);
Ma=max(I.Ma,[],2);



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [Exp,I]=CompExpFList(MatC,Me)
%Compute a Expectation: Mean or Variance (not Std!!!!) for every channel

NLab=length(MatC);
[Fe]=LoChFePoPh(MatC{1}); 
[FL,nf]=size(Fe);

%
S=[]; NS=[];
I.Me=zeros(FL,NLab); I.Std=zeros(FL,NLab); I.ModFrC=zeros(1,NLab);
I.Mi=zeros(FL,NLab); I.Ma=zeros(FL,NLab); I.ModBN=cell(1,NLab);

fprintf('Of %d: ',NLab);
for i=1:NLab
%for i=[2 3 4 200 201]    
    %
    fprintf('%d ',i); if mod(i,30)==0; fprintf('\n'); end   
    %
    [Fe]=LoChFePoPh(MatC{i});    
    [pn,bn]=fileparts(MatC{i});
    

    
    %For each individual model
    if ~isempty(Fe)        
        I.Me(:,i)=mean(Fe,2);
        I.ModFrC(:,i)=size(Fe,2);        
        I.Std(:,i)=std(Fe,[],2);    
        I.Mi(:,i)=min(Fe,[],2);
        I.Ma(:,i)=max(Fe,[],2);        
        I.ModBN{i}=bn;       
    end
    
    
    %For global    
    [SX,NSX]=CompSExp(Fe,Me);      
    S=[S SX]; 
    NS=[NS NSX];       
end
Exp=sum(S,2)/sum(NS);
fprintf('\n')


function [SX,NS]=CompSExp(X,Me)
%Compute Sum of Expectation
NS=size(X,2);
FL=size(Me,1);
if isempty(X)
    X2=zeros(FL,NS);  
elseif isempty(Me)
    X2=X;    
else    
    X2=(X-repmat(Me,[1,NS])).^2;
end
SX=sum(X2,2);


