function GlobTrDevPar(GParDir,TrDevModDir)
%Global Training Dev Parameters: Mean, Std, Histogram equalization transformation, ....
%
%GParDir:Global Parameter Dir
%TrDevModDir: Tr/Dev Model Dir (with individuals models)

%Output
GTrMat=[GParDir '/TrGPar.mat'];
GDevMat=[GParDir '/DevGPar.mat'];

%Input
TrDir=[TrDevModDir '/Tr'];
DevDir=[TrDevModDir '/Dev'];
TrMatC=LsBn12Ext(TrDir,'Tr','*','.mat');
DevMatC = strrep(TrMatC, [TrDir '/Tr'], [DevDir '/Dev']);



% %Me, Std
[GDev.Me,GDev.Std,GDev.Mi,GDev.Ma,GDev.I]=MeStdFList(DevMatC);
[GTr.Me,GTr.Std,GTr.Mi,GTr.Ma,GTr.I]=MeStdFList(TrMatC);
% HEq
%GTr=load(GTrMat); GDev=load(GDevMat); 
%[GDev.HEX,GDev.HEY,GDev.HEE]=TrHEqFList(DevMatC,GDev.Me,GDev.Std,GDev.Mi,GDev.Ma);
%[GTr.HEX, GTr.HEY, GTr.HEE]=TrHEqFList(TrMatC,GTr.Me,GTr.Std,   GTr.Mi, GTr.Ma);

%Save
save(GTrMat,'-struct','GTr');
save(GDevMat,'-struct','GDev');
fprintf('Written: %s\n',GTrMat)
fprintf('Written: %s\n',GDevMat)

%Check Me, Std
GTr=load(GTrMat); GDev=load(GDevMat); 
subplot(211), jplot(GTr.Me), mean(GTr.Me), hold on, jplot(GDev.Me,'r'),  hold off
subplot(212), jplot(GTr.Std), mean(GTr.Std), hold on, jplot(GDev.Std,'r'), hold off


% % %Check HEQ
% GTr=load(GTrMat); GDev=load(GDevMat); 
% CheckHEq(DevMatC,GDev.HEX,GDev.HEY,GDev.HEE);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function CheckHEq(MatC,HEX,HEY,HEE)
%

%Read
Fe=AppFeFList(MatC);

%Transf
Fe2=ChHistEq(Fe,HEX,HEY);

%Histograms
C=HistCountM(Fe,HEE); 
[Pdf,xx,xx]=HistCount2PdfCdfHEqTr(C,'Uniform');
C=HistCountM(Fe2,HEE); 
[Pdf2,xx,xx]=HistCount2PdfCdfHEqTr(C,'Uniform');


%Plot
[nch,NB]=size(Pdf);


for ch=1:nch
    
    x=HEX(ch,:);
    yor=Pdf(ch,:);
    yhe=Pdf2(ch,:);    
   
    
    subplot(311), jimagesc(Fe)  
    subplot(312), jimagesc(Fe2)
    subplot(313), plot(x,yor), hold on,  plot(x,yhe,'r'),   hold off, 
    xlim([-7 7]), legend('Orig', 'HEq')
    pause
end




function Fe=AppFeFList(MatC)
%
NLab=length(MatC);
Fe=[];
for i=1:NLab
%for i=1:2   
    fprintf('%d ',i); if mod(i,30)==0; fprintf('\n'); end
    F=LoChFePoPh(MatC{i}); 
    Fe=[Fe F];   
end







