function GlobTrDevModSamp(GTrDevModDir,TrDevModDir,P)
%Global Training Development Model Samples (generate samples to train
%global model, e.g. the MultiOutput SPN)
%GTrDevModDir: output (Global Tr/Dev Model)
%TrDevModDir: input (Tr/Dev Model Dir with individual models)

%Parameters
TrAsSGMod=2.5e6; %Training Asked Samples of Global Model (1e5 samples lates 7 hours the SPN training)


%Dirs
TrModDir=[GTrDevModDir '/Tr'];
DevModDir=[GTrDevModDir '/Dev'];
[x,x,x]=mkdir(TrModDir);
[x,x,x]=mkdir(DevModDir);
%
TrDir=[TrDevModDir '/Tr'];
DevDir=[TrDevModDir '/Dev'];
TrMatC=LsBn12Ext(TrDir,'Tr','*','.mat');
DevMatC = strrep(TrMatC, [TrDir '/Tr'], [DevDir '/Dev']);


%Asked samples per model and generate samples data of global model
NTrMod=length(TrMatC); %Number of Training Models
TrAsSMod=round(TrAsSGMod/NTrMod); %Training Asked Samples per Model
DevAsSMod=round(P.ExOpt.TrDevR*TrAsSMod); %Training Asked Samples per Model


%
CrTrDevGMod(TrModDir,DevModDir,TrMatC,DevMatC,'rc',TrAsSMod,DevAsSMod);



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function CrTrDevGMod(TrModDir,DevModDir,TrMatC,DevMatC,PermK,TrAsSMod,DevAsSMod)
%Create Training Development Global Model
NTrMod=length(TrMatC); %Number of Training Models
for i=1:NTrMod
    fprintf('%d/%d\n',i,NTrMod);    
    %Read Tr Dev samples of a Models   
    [Tr,Dev,NS]=TrDevMat2FePoPh(TrMatC{i},DevMatC{i},TrAsSMod,DevAsSMod,PermK,0);    
    %Append Model (feature and labels) To Global Model          
    AppMod2GMod(DevModDir,'DevGMod',Dev,i);
    AppMod2GMod(TrModDir,'TrGMod',Tr,i);   
end

fprintf('Written: %s\n',TrModDir);
fprintf('Written: %s\n',DevModDir);


function AppMod2GMod(TrModDir,BN,Tr,imod)
%Append Model (feature and labels)  To Global Model 
    
fn=[TrModDir '/' BN '.mat'];

if imod==1
    if exist(fn,'file'); delete(fn); end
    TrG=matfile(fn,'Writable',true);  
    ModNS=size(Tr.Fe,2); %Model Number of Samples 
    TrG.Feat=Tr.Fe;    
    TrG.ModO=Tr.ModO;
    TrG.Post=Tr.Po;
    %TrG.Phone=Tr.Ph; 
    %TrG.NS(1,imod)=ModNS;
    
    
    
else
    TrG=matfile(fn,'Writable',true); %we write directly on matlab file without loading in memory
    ModNS=size(Tr.Fe,2); %Model Number of Samples 
    %GModNS=length(TrG.ModO);    %Global Model Number of Samples       
    [xx,GModNS]=size(TrG,'ModO');    
    int=GModNS+1:GModNS+ModNS;       
    TrG.Feat(:,int)=Tr.Fe;    
    TrG.ModO(:,int)=Tr.ModO;
    TrG.Post(:,int)=Tr.Po;
    %TrG.Phone(:,int)=Tr.Ph; % it makes very slow
    %TrG.NS(1,imod)=ModNS;
end
    



