function [BN,ModC,ModOC,PoC,PhC]=AliGz2AlignDic(AliGz,Mdl,do,bn,P,TrModK)
%AliGz To Alignement Dictionary (BaseName, Phonemes and Posterior/Pdf)
%ModC: Model Cell. Must be strings (e.g. Phones)
%ModOC: Model Output Cell. Must be numbers (e.g. Posteriors)


%Outputs
TmpPdf      =[do '/' bn 'TmpPdf.txt'];
TmpPost     =[do '/' bn 'TmpPost.txt'];
TmpPh       =[do '/' bn 'TmpPh.txt'];

[x,x,x]=mkdir(do);

%
% c=[P.KaldiRoot '/bin/ali-to-pdf ' Mdl ' "ark:gunzip -c ' AliGz ' |" ark,t:' TmpPdf];system(c);
c=[P.KaldiRoot '/bin/ali-to-pdf ' Mdl ' "ark:gunzip -c ' AliGz ' |" ark:- | ' P.KaldiRoot '/bin/ali-to-post ark:- ark,t:' TmpPost]; system(c);
% c=[P.KaldiRoot '/bin/ali-to-post "ark:gunzip -c ' AliGz ' |" ark,t:' TmpPost]; system(c);
c=[P.KaldiRoot '/bin/ali-to-phones --per-frame=true ' Mdl ' "ark:gunzip -c ' AliGz ' |" ark,t:' TmpPh]; system(c);

%Ph
[PhBN,PhNC]=ReKaldAlign(TmpPh,'ph');
PhC=PhN2Ph(PhNC,P.PhPhNDic);  %Phone Number To Name

%Post
[BN,PoC]=ReKaldAlign(TmpPost,'post');

%
delete(TmpPost,TmpPh)

%

switch TrModK
    case 'PoPo'      
        ModC=Num2StrCell(PoC);     
        ModOC=PoC;
    case 'PhPo'
        ModC=PhC;
        ModOC=PoC;
    case 'PhPh'
        ModC=PhC;
        ModOC=PhNC;        
    case 'GPh'
        ModC=Ph2ModDic(PhC,P.Ph2GPhDic);            
     case 'GPhGPh'
        ModC=Ph2ModDic(PhC,P.Ph2GPhDic); 
        ModOC=ModC;        
    case 'SVU' %FUTURE
        ModC=Ph2ModDic(PhC,P.Ph2SVUDic);        
end





% %Save to use in discriminative training.
% MatF=[do '/Ali' bn '.mat'];
% save(MatF,'BN','PhC','PoC');    
% fprintf('Written: %s\n',MatF);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function ModC=Ph2ModDic(PhC,Dic)
%Phoneme To Mod using a Dictionary
[AKey,AVal]=ReDictF(Dic);
[Key,in,en]=Cell2M(PhC);
Val=Key2ValDict(Key',AKey',AVal',1);
ModC=M2Cell(Val,in,en);

