function SpnTr1Mod(FinalSpnDir,GParDir,TrDevModDir,GTrDevModDir,SpnTrKC,MvnK,NG,P)
%Spn Training for One Model
%
%FinalSpnDir: output SPN Dir
%
%GParDir: Global Parameters Dir
%TrDevModDir: Tr/Dev Model Dir (where are the training/development data)
%SpnTrKC: Spn Training Kind Cell 
%MvnK: Mean Variance Normalization Kind
%NG: Number of Gaussians
%P: Parameter structure

for i=1:length(SpnTrKC)
    
    %MultO (then Global PoPo)
    SpnTrK=SpnTrKC{i};    
    if ~isempty(strfind(SpnTrK,'MultO')) 
        TrMod='GMod';     %Training Model         
        ModDir=GTrDevModDir;            
    else
        TrMod=num2str(P.TeOpt1);   
        ModDir=TrDevModDir; 
    end       
    SpnTr1ModMain(FinalSpnDir,GParDir,ModDir,TrMod,SpnTrK,MvnK,'rc',NG,P)        
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function SpnTr1ModMain(FinalSpnDir,GParDir,ModDir,TrMod,SpnTrK,MvnK,PermK,NG,P)
%Spn Training for One Mode (Main function)
%Structure and FineTuning training


%
C=strsplit(SpnTrK,'_'); 

%Read and normalize data
[AsTr,AsDev,AsFiTr,AsFiDev]=AsNSStrTun(P.ExOpt.TrNS,P.ExOpt.TrDevR,P.ExOpt.PDFiR);
[Tr,Dev,FiTr,FiDev,Info]=TrDevNormData(GParDir,ModDir,TrMod,AsTr,AsDev,AsFiTr,AsFiDev,MvnK,PermK,P.ExOpt.MixTrDevSamp);

%Mat2Ali4DnnTr([FinalSpnDir '/Tmp'],FiTr,FiDev)

%1) Structure training with P&D 
SpnModDir = [FinalSpnDir '/SpnMod_' C{1} '_' MvnK]; [x,x,x]=mkdir(SpnModDir); 
modelFile = [SpnModDir '/Spn' TrMod '.mod'];
if ~exist(modelFile,'file')
     switch C{1}
         case 'Gmm'                    
             GmmTr(modelFile,Tr.X,Tr.Y,Dev.X,Dev.Y,P.SpnBinDir,NG,P);        
          %case {'Dnn', 'DnnMultO'}        
          %   DnnTr(modelFile,FiTr.X,FiTr.Y,FiDev.X,FiDev.Y,P.SpnBinDir,NG,P,TrMod);             
         case {'Spn', 'SpnMultO'}
             Ju2RoSpnPdTr(modelFile,Tr.X,Tr.Y,Dev.X,Dev.Y,P.SpnBinDir,NG,P,P.ExOpt.SpnVers);                    
         otherwise
     end        
    SaMod2MatSpn(modelFile,Tr.Y,Dev.Y,Info,TrMod);     
end


%2) Fine Tuning (EM, Discriminative Training...)
if length(C)>=2

    %Id=[num2str(P.TrOpt1) '_' num2str(P.TrOpt2) '_' num2str(P.TeOpt1) '_' num2str(P.TeOpt2)];
    SpnModDir2 = [FinalSpnDir '/SpnMod_' C{1} '_' C{2} '_' MvnK]; [x,x,x]=mkdir(SpnModDir2);
    modelFile2 = [SpnModDir2 '/Spn' TrMod '.mod'];
    %if ~exist(modelFile2,'file')
        
        switch C{2}
            case 'EM'
                Ju2RoSpnEmTr(modelFile2,modelFile,FiTr.X,FiTr.Y,FiDev.X,FiDev.Y,P.SpnBinDir,P);
            case {'NPseLik','CE','NMMI'}
                SpnDiscrTr(modelFile2,modelFile,TrMod,FiTr.X,FiTr.Y,FiDev.X,FiDev.Y,C{2},Info,P);
            otherwise
        end
        SaMod2MatSpn(modelFile2,FiTr.Y,FiDev.Y,Info,TrMod);
    %end
    
end



