function SpnTr(SpnResDir,GmmResDir,P)
%Sum Product Network Training
%SpnResDir: output (Spn Results Directory) 
%GmmResDir: input (Gmm Results Directory, where to find Chime3 Gmm results)
%P: Parameter structure

%Dirs
FinalSpnDir = [SpnResDir '/FinalSpn'];
GParDir     = [FinalSpnDir '/GPar'];
[x,x,x]=mkdir(SpnResDir); 
[x,x,x]=mkdir(FinalSpnDir); 

%Dirs
TrModK='PoPo'; %Training Model Kind: 'PoPo', 'PhPo', 'SVU'
TrDevModDir       = [SpnResDir '/' TrModK]; 
GTrDevModDir      = [SpnResDir '/G' TrModK];

%Fies from Dnn
FeTran      = [FinalSpnDir '/final.feature_transform'];
priorPath   = [FinalSpnDir '/ali_train_pdf.counts'];
HCLG        = [FinalSpnDir '/HCLG.fst'];
Mdl         = [FinalSpnDir '/final.mdl']; 
TrAli       = [GParDir '/TrAli.1.gz'];
DevAli      = [GParDir '/DevAli.1.gz'];

%1) Copy neccesary files from Chi3 Dnn training
%CpDnnF4SpnTr(GmmResDir,Mdl,FeTran,priorPath,HCLG,TrAli,DevAli);

%2) Prepare using the alignement the Tr, Dev and Global sets of samples to train Spn models 
%TrDevModSamp(TrDevModDir,TrAli,DevAli,Mdl,P,TrModK);
%GlobTrDevModSamp(GTrDevModDir,TrDevModDir,P);

%3) Estimate global parameters
%GlobTrDevPar(GParDir,TrDevModDir);



%4) Spn training of 1 Model
SpnTr1Mod(FinalSpnDir,GParDir,TrDevModDir,GTrDevModDir,P.ExOpt.SpnTrK,P.ExOpt.MvnK,P.ExOpt.NG,P)




