function DiscrSpnTr(FinalSpnDir,P)
%

%
FrBatchS=20; %Frame Batch Size
UtBatchS=3; %Utterance Batch Size
TrDir=P.TrDir(1:4);


%
NPdf=1985;
SpnMatDir=[FinalSpnDir '/SpnMat0'];
AppFa2Spn(SpnMatDir,NPdf); %Append fatherIdx if not exist



%
%1)
% Add to FETr: DiscrSpnTrFE(x,do,bn,P); 
% Add to TrTeParam: P.TrAli=load([P.ExpHmmDir '/Spn/Tr/AliTr.mat']); %Very heavy!!!
% Remove Dev from TrDir??

%2)File List and shuffle 
CList=[];
for i=1:length(TrDir)
    FeatDir=[P.FeatDir '/' TrDir{i}];
    CList=[CList; LsBn12Ext(FeatDir,'','*','.mat')];    
end

l=length(CList);
CList=CList(randperm(l));

%Batch training
i=1;
while i<=l
    j=1;
    Fe=[];
    AliPdf=[];
    NBestPdf=[];
    
    while j<=UtBatchS && i<=l        
        S=load(CList{i});
        AliPdf=[AliPdf S.AliPdf];
        NBestPdf=[NBestPdf S.NBestPdf];        
        [pn,bn]=fileparts(CList{i});       
        A=ReadHTKF([pn '/' bn(4:end) '.Fbx'],0,0); %remove Pdf
        Fe=[Fe A];             
        i=i+1; j=j+1;        
    end
    
    %Shuffle data
    nf=length(AliPdf);
    p=randperm(nf);
    %p=1:nf;
    Fe=Fe(:,p);
    AliPdf=AliPdf(:,p);
    NBestPdf=NBestPdf(:,p);
        
    %Main batch
    in=1; en=in+FrBatchS-1;
    while in<=nf
        int=in:en;
        DiscrSpnTrBatch(SpnMatDir,Fe(:,int),AliPdf(:,int),NBestPdf(:,int));         
        in=en+1; en=min(nf,in+FrBatchS-1);        
    end   
    
end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function DiscrSpnTrBatch(SpnDir,Y,AliPdf,NBestPdf)
%

%Idea: pass samples for the same Pdf

unique(NBestPdf);
i=1;
S=load([SpnDir '/Spn' num2str(i-1) '.mat']); %Temporal
Spn=S.Spn; Me=S.Me; Std=S.Std; Info=S.Info;
Fe=MeStdNorm(Y,Me,Std);

DLW=Back1Spn(Fe,-1,Spn,-1,'Spn')

subplot(311), jimagesc(Fe)
subplot(312), jplot(AliPdf)
subplot(313), jplot(NBestPdf')
pause




