function GenInfo(InfoDir,FeatRoot,ufo,fek,P)
%Compute the Ark of the feature, cmvn and text transcription for Dev and Tr  


%For every ufo{:} folder, read all Htk files and generate (in InfoDir) one ark, scp and text
[x,x,x]=rmdir(InfoDir,'s'); [x,x,x]=mkdir(InfoDir);
Htk2KaldSevFo(InfoDir,FeatRoot,ufo,fek,P);


%Join all the individual feature lists (of ufo{:} folders) at one full list (FeatScp)
FeatScp=[InfoDir '/FeatScp.txt'];
JoinListFoSort(FeatScp,InfoDir,ufo,[fek 'FeatScp.txt']);

%Here it could be: Modify FeatRoot of the full list (used when change to GPU)
ModRootDic(FeatScp,FeatScp,InfoDir);



%Join as before but for Text
JoinListFoSort([InfoDir '/Text.txt'],InfoDir,ufo,[fek 'Text.txt']);

%Generate CmvnFeat.ark, etc..
FeatScp2Cmvn([InfoDir '/CmvnFeat.ark'],[InfoDir '/CmvnScp.txt'],[InfoDir '/Spk2Utt.txt'],[InfoDir '/Utt2Spk.txt'],[InfoDir '/FeatScp.txt'],P.KaldiRoot);



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function ModRootDic(FeatScpO,FeatScp,CurInfoDir)
%
[Key,Val]=ReDictF(FeatScp);
l=length(Val);
ValO=cell(l,1);
for i=1:l         
    [p1,b1]=fileparts(Val{i}); [p2,b2]=fileparts(p1); [OldInfoDir,b3]=fileparts(p2);      
    ValO{i} = strrep(Val{i}, OldInfoDir, CurInfoDir);    
end
WrDictF(FeatScpO,Key,ValO);



function Htk2KaldSevFo(InfoDir,FeatRoot,Fo,fek,P)
%Htk To Kaldi of Several Folders
for i=1:length(Fo)
    IDir=[FeatRoot '/' Fo{i}];
    ODir=[InfoDir '/' Fo{i}]; [x,x,x]=mkdir(ODir);
    Htk2KaldDir(ODir,IDir,fek,P.TransDir,P.KaldiRoot);   
end



function JoinListFoSort(List,Root,Fo,ListBN)
%Join Lists of several Folders
%Info: 'MfccFeatScp.txt', 
TmpList=[List '.tmp']; if exist(TmpList,'file'); delete(TmpList); end
for i=1:length(Fo)    
    f=[Root '/' Fo{i} '/' ListBN];    
    system(['cat ' f ' >> ' TmpList]);
end
[B,T]=ReDictF(TmpList);
[BS,I]=sort(B); TS=T(I);
WrDictF(List,BS,TS);
delete(TmpList);




