function CpDnnF4SpnTr(DnnRes,Mdl,FeTran,priorPath,HCLG,TrAli,DevAli)
%Copy Dnn Files For Spn Training. The DNN files are obtained from the baseline
%CHIME3 training of DNNs
%
%From CHIME3 baseline you can copy them manually as follow
% mkdir 4Spn; cp Results/FE_0_0_0_0/HMM_0_0/Dnn/MDir/exp/tri3b_tr05_multi_enhanced_ali/final.mdl 4Spn
% cp Results/FE_0_0_0_0/HMM_0_0/Dnn/MDir/exp/tri4a_dnn_tr05_multi_enhanced/final.feature_transform 4Spn
% cp Results/FE_0_0_0_0/HMM_0_0/Dnn/MDir/exp/tri4a_dnn_tr05_multi_enhanced/ali_train_pdf.counts 4Spn
% mkdir 4Spn/Tr; cp Results/FE_0_0_0_0/HMM_0_0/Dnn/MDir/exp/tri3b_tr05_multi_enhanced_ali/ali.*.gz 4Spn/TrAli.*.gz
% mkdir 4Spn/Dev; cp Results/FE_0_0_0_0/HMM_0_0/Dnn/MDir/exp/tri3b_tr05_multi_enhanced_ali_dt05/ali.*.gz 4Spn/DevAli.*.gz
%For FMLLR 
% cp /home/jmorales/Mnt/GPUHome/Results/FE_0_0_0_0/HMM_0_0/Dnn/MDir/exp/tri3b_tr05_multi_enhanced_ali/trans.1 4Spn/Trtrans.1
% cp /home/jmorales/Mnt/GPUHome/Results/FE_0_0_0_0/HMM_0_0/Dnn/MDir/exp/tri3b_tr05_multi_enhanced_ali_dt05/trans.1 4Spn/Devtrans.1



%Hmm and language model
CpJ(DnnRes,Mdl);
CpJ(DnnRes,FeTran);
CpJ(DnnRes,priorPath);
CpJ(DnnRes,HCLG);

%Fmllr transformation
DestDir=fileparts(Mdl);
CpJ(DnnRes,[DestDir '/Trtrans.1']);
CpJ(DnnRes,[DestDir '/Devtrans.1']);
CpJ(DnnRes,[DestDir '/Tetrans.1']);

%Alignements
[p1]=fileparts(TrAli);
[p2,b2]=fileparts(p1);
OrigDir=[DnnRes '/' b2];
CpJ(OrigDir,TrAli);
CpJ(OrigDir,DevAli);



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function CpJ(OrigDir,DestF)
%
[DestDir,bn,ext]=fileparts(DestF);
system(['mkdir -p ' DestDir]);
copyfile([OrigDir '/' bn ext],DestF);
fprintf('Written: %s\n',DestF);



%Training
% nnet-train-frmshuff --learn-rate=0.0005 --momentum=0 --l1-penalty=0 --l2-penalty=0 --minibatch-size=256 --randomizer-size=32768 --randomize=true --verbose=1 
% --binary=true --feature-transform=/users/multispeech/jmorales/Results/FE_0_0_0_0/HMM_0_0/Dnn/MDir/exp/tri4a_dnn_tr05_multi_enhanced/final.feature_transform 
% --randomizer-seed=777 ark:copy-feats scp:/users/multispeech/jmorales/Results/FE_0_0_0_0/HMM_0_0/Dnn/MDir/exp/tri4a_dnn_tr05_multi_enhanced/train.scp ark:- | 
% 
% ark:ali-to-pdf /users/multispeech/jmorales/Results/FE_0_0_0_0/HMM_0_0/Dnn/MDir/exp/tri3b_tr05_multi_enhanced_ali/final.mdl 
% "ark:gunzip -c /users/multispeech/jmorales/Results/FE_0_0_0_0/HMM_0_0/Dnn/MDir/exp/tri3b_tr05_multi_enhanced_ali/ali.*.gz |" ark:- | ali-to-post ark:- 
% ark:- | /users/multispeech/jmorales/Results/FE_0_0_0_0/HMM_0_0/Dnn/MDir/exp/tri4a_dnn_tr05_multi_enhanced/nnet/nnet_7.dbn_dnn_iter08_learnrate0.001_tr1.1284_cv2.0376 /users/multispeech/jmorales/Results/FE_0_0_0_0/HMM_0_0/Dnn/MDir/exp/tri4a_dnn_tr05_multi_enhanced/nnet/nnet_7.dbn_dnn_iter09

%Cross-validation
%nnet-train-frmshuff --cross-validate=true --minibatch-size=256 --randomizer-size=32768 --randomize=false --verbose=1 
%--feature-transform=/users/multispeech/jmorales/Results/FE_0_0_0_0/HMM_0_0/Dnn/MDir/exp/tri4a_dnn_tr05_multi_enhanced/final.feature_transform 
%ark:copy-feats scp:/users/multispeech/jmorales/Results/FE_0_0_0_0/HMM_0_0/Dnn/MDir/exp/tri4a_dnn_tr05_multi_enhanced/cv.scp ark:- | 
%
%ark:ali-to-pdf /users/multispeech/jmorales/Results/FE_0_0_0_0/HMM_0_0/Dnn/MDir/exp/tri3b_tr05_multi_enhanced_ali/final.mdl 
%"ark:gunzip -c /users/multispeech/jmorales/Results/FE_0_0_0_0/HMM_0_0/Dnn/MDir/exp/tri3b_tr05_multi_enhanced_ali_dt05/ali.*.gz |" ark:- | ali-to-post ark:- 
%ark:- | /users/multispeech/jmorales/Results/FE_0_0_0_0/HMM_0_0/Dnn/MDir/exp/tri4a_dnn_tr05_multi_enhanced/nnet/nnet_7.dbn_dnn_iter01


%Prior can be obtained as in train.sh: analyze-counts --verbose=1 --binary=false "$labels_tr_pdf" $dir/ali_train_pdf.counts 2>$dir/log/analyze_counts_pdf.log || exit 1

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


