function CopyLM4GMM(LMS,LMD)
%Copy Language Model files For GMMs (only the Neccessary)
%Better than system(['cp -r ' P.SpeechRoot '/CHIME3_All/LM' ' ' HmmRoot '/']);


%Mono
CpLMF('lang/L.fst',LMS,LMD); %Lexicon. Binary 

CpLMF('lang/oov.int',LMS,LMD); %Out of Vocabulary words 
CpLMF('lang/phones/sets.int',LMS,LMD);
CpLMF('lang/topo',LMS,LMD); %Topology of initial HMMs
CpLMF('lang/words.txt',LMS,LMD);
CpLMF('lang/phones/optional_silence.csl',LMS,LMD); %One silence 1
CpLMF('lang/phones/silence.csl',LMS,LMD); %Needed by train_lda_mllt.sh
CpLMF('lang/phones/extra_questions.int',LMS,LMD); %Needed by train_lda_mllt.sh


%Delta
CpLMF('lang/phones.txt',LMS,LMD);
CpLMF('lang/phones/context_indep.csl',LMS,LMD); %1:2:3:4:5:6:7:8:9:10:11:12:13:14:15
CpLMF('lang/phones/roots.int',LMS,LMD);

%Graph
CpLMF('lang_test_tgpr_5k/L.fst',LMS,LMD); %Lexicon. the same as Mono
CpLMF('lang_test_tgpr_5k/phones.txt',LMS,LMD); %the same as Delta
CpLMF('lang_test_tgpr_5k/words.txt',LMS,LMD); %the same as Mono
CpLMF('lang_test_tgpr_5k/phones/silence.csl',LMS,LMD); %the as context_indep.csl: List of silences 1:2:...:15

CpLMF('lang_test_tgpr_5k/G.fst',LMS,LMD); %Grammar
CpLMF('lang_test_tgpr_5k/phones/disambig.int',LMS,LMD);
CpLMF('lang_test_tgpr_5k/L_disambig.fst',LMS,LMD);




%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function CpLMF(fn,LMS,LMD)
%Copy Language Model File
fnd=[LMD '/' fn];
[pn, bn]=fileparts(fnd);
system(['mkdir -p ' pn]);
copyfile([LMS '/' fn],fnd);
fprintf('Copied %s in %s\n',[LMS '/' fn],fnd);


