function [s,L]=Recog(Feat,AdaptId,do,bn,P)
%Recognition

RecDir      = [P.RecRoot '/RecStages'];

P.Config    = [RecDir '/TrainGen/TrainDir/Common/MVConfig.txt']; 
P.Dic 		= [RecDir '/TestGen/TestDir/' P.SDBase '/' P.RecPref 'W2AUDic.txt']; 

P.LMSCALE       = '15';
P.PRUNINGTH     = '250';
P.WEPRUNING 	= '150';
P.MAXACTIVE 	= '0';     
P.TunPar 		= [' -s ' P.LMSCALE ' -p ' num2str(P.WPenalty) ' -t ' P.PRUNINGTH ' -v ' P.WEPRUNING ' -u ' P.MAXACTIVE];


%
%P.WoTriPhList = [RecDir '/TestGen/TestDir/' P.SDBase '/WList.txt'];
%P.WPenalty 	= '0.0'; 
%P.TunPar 	= ['-p ' P.WPenalty];
KDec='Htk';
if P.SpDep; 
   KDec='SpDepHtk'; 
   P.AdaptHmmDir=[P.HmmDir '/AdaptRTC/' AdaptId];
end


%
switch KDec
    
    case 'Htk'
        [s,L]=HtkTe(Feat.CxestD,do,bn,P);
        
    case 'SpDepHtk' 
        [s,L]=SpDepHtk(Feat.CxestD,do,bn,P);       
        
end
   
%s=regexprep(s,{'!JENTER','!JEXIT','!NULL','sil','\x{2E}'},{''});

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [s,L]=HtkTe(Feat,do,bn,P)
%
%-a -o SM for time alignement.  -a -o ST for not
TempMlfRes  = [do '/' bn 'TempMlfRes.txt'];
TempStEO    = [do '/' bn 'StEO.txt'];
FeatF       = [do '/' bn '.Cxest']; WriteHTKF(FeatF, Feat, 0, 0);

s = [P.HtkDir '/HVite -T 1 -C ' P.Config ' -H ' P.Hmm  ' -w ' P.Gram ' -i ' TempMlfRes ...
    ' -l ' '''*''' ' -a -o ST ' P.TunPar ' ' P.Dic ' ' P.WoTriPhList ' ' FeatF ' > ' TempStEO];
fprintf('Recognizing %s with HMM: %s\n', bn, P.Hmm);

system(s);

%L=ReRecLik(TempStEO);
L=-1;

fi=fopen(TempMlfRes,'r');C=textscan(fi,'%s %s %s'); C=C{:}; fclose(fi);
C=C(3:end-1); s=sprintf('%s ',C{:});
delete(TempMlfRes,TempStEO);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [s,L]=SpDepHtk(Feat,do,bn,P)
%
XFormDir    = [P.AdaptHmmDir '/XFormDir'];
ClasDir     = [P.AdaptHmmDir '/ClasDir'];
TempMlfRes  = [do '/' bn 'TempMlfRes.txt'];
TempFList   = [do '/' bn 'TempFList.txt'];
TempStEO    = [do '/' bn 'StEO.txt'];
TempExe     = [do '/' bn 'Exe.sh'];

FeatF=[do '/adapt' bn '.Cxest']; 
WriteHTKF(FeatF, Feat, 0, 1);
fi=fopen(TempFList,'w'); fprintf(fi,'%s\n',FeatF); fclose(fi);

s=[P.HtkDir '/HVite -T 1 -C ' P.Config ' -H ' P.Hmm ' -w ' P.Gram ' -i ' TempMlfRes ' -S ' TempFList ... %-n 4 -z lat
    ' -l ' '''.''' ' -a -o ST ' '-J ' XFormDir ' mllr2 -h ''*/%%%%%*''.Cxest -k -J ' ClasDir ' ' ... 
    P.TunPar ' ' P.Dic ' ' P.WoTriPhList ' > ' TempStEO];

fprintf('Recognizing with HMM: %s\n', XFormDir);
%eval(['! bash' s]);
system([s]);
L=ReRecLik(TempStEO);
%fi=fopen(TempExe,'w'); fprintf(fi,'#!/bin/csh\n'); fprintf(fi,'%s\n',s); fclose(fi);
%system(['csh ' TempExe]);
fi=fopen(TempMlfRes,'r');C=textscan(fi,'%s %s %s'); C=C{:}; fclose(fi);
C=C(3:end-1); s=sprintf('%s ',C{:});
delete(TempMlfRes,TempStEO,TempFList);


function L=ReRecLik(TempStEO)
%Read Recognition Likelihood. The information is in the last row of StEO with (HVite -T 1) 
fi=fopen(TempStEO,'r');
l = fgetl(fi);
while ischar(l)
    lp=l;
    l=fgetl(fi);    
end
fclose(fi);
%
C=strsplit(lp,' == '); lp=C{2}; C=strsplit(lp,' ');
%
a=C{2}; L.NF          = str2double(a(2:end)); %Number of Frames
a=C{4}; L.AvLogPrFr   = str2double(a); %Average log probability  per frame
a=C{5}; L.Ac          = str2double(a(5:end)); %Total acoustic likelihood,
a=C{6}; L.LM          = str2double(a(4:end-1)); %Total language model likelihood
a=C{7}; L.Act         = str2double(a(6:end-1)); %Average number of active models.




