function RecDir(do,dy,SMRoot,SoftRoot,SpeechRoot,RecRoot,ExtraFunRoot,KaldiTrunkRoot,ExOptF,RecSt,FEOpt1,FEOpt2,FEOpt3,FEOpt4,TrOpt1,TrOpt2,TeOpt1,TeOpt2)
%Recognizer of a noisy Directory (including training) 
%do         : Output dir
%dy         : Noisy dir 
%SMRoot     : Script Matlab Root, SoftRoot (Softwares Root), etc...
%SDBase     : Speech DataBase, 
%RecSt      : Recognition Stage
%FEOpt1-4   : FE Options (string numbers)
%TeOpt1-2:  : Test Options (string numbers)


%Basic Parameters
P.SMRoot    = SMRoot; 
P.SoftRoot  = SoftRoot;
P.SpeechRoot= SpeechRoot;
P.RecRoot   = RecRoot;
P.ExtraFunRoot=ExtraFunRoot;
P.KaldiTrunkRoot=KaldiTrunkRoot;

P.RecSt     = RecSt;
P.FEOpt1 = str2double(FEOpt1); P.FEOpt2 = str2double(FEOpt2); 
P.FEOpt3 = str2double(FEOpt3); P.FEOpt4 = str2double(FEOpt4);


P.TrOpt1 = str2double(TrOpt1); P.TrOpt2 = str2double(TrOpt2);
P.TeOpt1 = str2double(TeOpt1); P.TeOpt2 = str2double(TeOpt2);

%Parameters in structure P
Aux = load(ExOptF); P.ExOpt = Aux.ExOpt;
P.DBSize    = P.ExOpt.DBSize;
P.SDBase    = P.ExOpt.SDBase;
P   = FEParam(do,dy,P);
P   = TrTeParam(do,P);

%
switch P.RecSt
    
    case 'Tr'
        %ClTr(do,P.VadClMDir,P.VadClK,100);
        TrRec(do,P);        
        %TrImpGmm(do,P);
        %TrImpSampMod(do,P);
        
    case 'FETr'
        [S]=FETrTeDir(dy,do,P);
        
    case {'FETe'}
        [S]=FETrTeDir(dy,do,P);
        %save('p.mat')
        %S2=load('p.mat'); S=S2.S;
           
        
        RecPerfDirKald(S,do,P);
        %RecPerf(S,do,P);
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%




