function [P]=FEParam(do,dy,P)
%Feature Extractor Parameters depending on Speech DataBase (SDBase)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Analize dy and do
[pn, bn] = fileparts(dy);
P.dy    = dy; %(/home/jmorales/SpeechData/CHIME3_All/TeSpl/et05_bus_simu_1)
P.dn    = [pn '/' bn '_noise']; %/home/jmorales/SpeechData/CHIME3_All/TeSpl/et05_bus_simu_1_noise
%P.dx    = [pn '/' bn 'Clean']; %(/home/jmorales/SpeechData/CHIME3_All/TeSpl/et05_bus_simu_1Clean)
%P.denh  = [pn 'Enh/' bn]; %/home/jmorales/SpeechData/CHIME3_All/TeSplEnh/et05_bus_simu_1




%Get information from do. Root from /home to /home/ExpRoot. Dir after
[p1,b1]=fileparts(do); [p2,b2]=fileparts(p1); [p3,b3]=fileparts(p2); [p4,b4]=fileparts(p3);
P.SpCond1=b2; %Speech Condition 1 (TeSpl)
P.SpCond2=b1; %Speech Condition 2 (et05_bus_simu_1)
P.FeatDir=p2; %FeatDir (/home/jmorales/Results/FE_0_0_0_0/Feat)
P.ExpRoot=p3; %Experiment Root (/home/jmorales/Results/FE_0_0_0_0)
P.ResRoot=p4; %Experiment Root (/home/jmorales/Results)
P.ExpResDir=[P.ExpRoot '/Res']; %Exp Res Dir  (/home/jmorales/Results/FE_0_0_0_0/Res) (not confuse with ResRoot of before and with of AllRec.m (/home/jmorales/Results))




%Param
%
P.FLSec     = 0.032; %Frame Length in Seconds
P.FSSec     = 0.010; %Frame Shift in Seconds
P.NCH       = 40; %Number of Channel (Mel or Gammatone filterbank)
%P.NCH       = 23; %Number of Channel (Mel or Gammatone filterbank) 
%P.NCH       = 5; %November 19

P.CepL      = 13;
P.PhLSec    = 1/4; %Ph Lenght in Seconds (inverse of the famous [3-7] Hz) 

P.MF        = -7.6362;  %Min Floor in Log-Mel-Msd
%P.MF        = -8; %Min Floor in Log-Mel-Msd (really not used by VTS, in future obtain put in Gmm)
%P.MinMS     = exp(P.MF); 

P.YExt      = '.wav'; %A2: '.08'; A4: '.wv1'
P.XExt      = '.wav';
P.SoundSp   = 343; %Sound Speed
P.MaPitHz   = 270; %Max Pitch (Hz) (270 Hz)
P.MiPitHz   = 80; %Min Pitch (Hz) (80 Hz)
%
P.ImpNGaus  = '128'; 
%P.ImpNGaus  = '8'; 

%Models
%P.JuanKaldFeat  = 'JuanFeat'; %'KaldFeat';
P.RoomLocMDir   = [P.SpeechRoot '/Models/RoomLocM/RoomLocM'];  
P.ImputeGmmDir  = [P.SpeechRoot '/Models/Impute/Gmm' P.SDBase 'JuanFeat' P.ImpNGaus];
P.ImpSamMDir  = [P.SpeechRoot '/Models/Uncert/ImpSamp' P.SDBase];

%P.HmmTr=~isempty(strfind(dy,'Train')); %we are processing as Train

%DBaseParam
switch P.SDBase
    
    case {'CHIME3'}        
        P.AnnotDir=[P.SpeechRoot '/' P.SDBase '_All/Info/annotations'];
        P.EmbRoot =[P.SpeechRoot '/' P.SDBase '_All/Emb'];
        P.BackRoot=[P.SpeechRoot '/' P.SDBase '_All/Back'];
        P.EnhRoot = [P.SpeechRoot '/' P.SDBase '_All/enhanced'];
        
        
        P.RefMic=5+1;
    
    case {'FBKGEDIRHA','DIRHAGRID','EMBEDDIRHA'}
        
        [P.KA6,P.LA6,P.R1C,P.C1R,P.B2C]=FbkMicArrPar(P,dy);           
        
        
        P.AMicN={'K1R' 'K1L' 'K2R' 'K2L' 'K3R' 'K3C' 'K3L' 'KA6' 'KA1' 'KA2' 'KA3' 'KA4' 'KA5' 'L1R' ... 
            'L1C' 'L1L' 'L2R' 'L2L' 'L3R' 'L3L' 'L4R' 'L4L' 'LA6' 'LA1' 'LA2' 'LA3' 'LA4' 'LA5' 'C1R' ...
            'C1L' 'R1R' 'R1C' 'R1L' 'B1R' 'B1L' 'B2R' 'B2C' 'B2L' 'B3R' 'B3L'};

            
        if strcmp(P.SDBase,'EMBEDDIRHA'); P.AMicN={'LA1' 'LA2' 'LA3' 'LA4' 'LA5' 'LA6'}; end


        P.ARoomN={'K' 'L' 'R' 'C' 'B'};        
        
        P.ARoomRefMicN={'KA6' 'LA6' 'R1C' 'C1R' 'B2C'};        
        P.MicPairLa.K={{'K1R' 'K1L'}, {'K2R' 'K2L'}, {'K3R' 'K3C'}, {'KA4' 'KA6'}};
        P.MicPairLa.L={{'L1C'  'L1L'}, {'L2R'  'L2L'}, {'L3R'  'L3L'}, {'L4R'  'L4L'}, {'LA3'  'LA6'}};
        P.MicPairLa.R={{'R1R' 'R1C'}, {'R1C' 'R1L'}};
        P.MicPairLa.C={{'C1R' 'C1L'}};
        P.MicPairLa.B={{'B1L' 'B1R'}, {'B2C' 'B2R'}, {'B3R' 'B3L'}};             
        
        %MlfIF=[RecRoot '/RecStages/TestGen/TestDir/FBKGEDIRHA/MlfWTrans.txt'];
        %[S]=Mlf2BNTranDic(MlfIF);  P.BNTransDic.BN=S.BN; P.BNTransDic.WTrans=S.Trans;     
             
        
     case 'A2' 
        P.YExt='.08'; %A2: '.08'; A4: '.wv1'
        P.XExt='.08';
        P.EndianFormat='b';
          
end



