function AnalRes(ResRootI,YDir,ExMach,AsrResRoot,JHome,P,FEOpt1,FEOpt2,FEOpt3,FEOpt4,TrOpt1,TrOpt2,TeOpt1,TeOpt2)
%Analyze Results




%Juan To Grid Paths for ResRoot
[ResRoot]=Juan2GridPathJobC({ResRootI},'r',AsrResRoot,JHome,getenv('username'),'xx','xx',ExMach); 
ResRoot=ResRoot{1};



%Training or Front End
OptV=combvec(FEOpt1,FEOpt2,FEOpt3,FEOpt4,TrOpt1,TrOpt2,TeOpt1,TeOpt2);


%
ldc=length(YDir); %length of dir counter
NE=size(OptV,2); %options counter



%
Wer=zeros(NE,ldc);
JWer=zeros(NE,1);
I=zeros(NE,ldc); D=zeros(NE,ldc); S=zeros(NE,ldc); N=zeros(NE,ldc);

for oc=1:NE
    Opt=OptV(:,oc);     
    [Wer(oc,:),I(oc,:),D(oc,:),S(oc,:),N(oc,:)]=ReRes1Exp(Opt,ResRoot,YDir);        
    JWer(oc)=PrintRes(Opt,Wer(oc,:),I(oc,:),D(oc,:),S(oc,:),N(oc,:));   
end


%Best
[v,oc]=min(JWer);
fprintf('\nBest experiment is:\n');
PrintRes(OptV(:,oc),Wer(oc,:),I(oc,:),D(oc,:),S(oc,:),N(oc,:));

%Print
fprintf('\nSummary:\n');
fprintf('%.2f ',JWer);
fprintf('\n')


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function JWer=PrintRes(Opt,Wer,I,D,S,N)
%
% %Group Average
% GAvL=1;
% L=length(Wer); NG=floor(L/GAvL); GWer=zeros(1,NG); %Group Wer
% for i=1:NG;    in=((i-1)*GAvL)+1;    en=in+GAvL-1;    GWer(i)=mean(Wer(in:en)); end
%GWer=Wer;


i=isnan(Wer);
l=length(Wer);
if sum(i)>1
    j=not(i);
    Wer=Wer(j);    
    S=S(j);
    D=D(j);
    I=I(j);
    N=N(j);
    warning('NaN removed. Reduction from %d to %d', l, length(Wer))    
end

%Print
SI=sum(I); SD=sum(D); SS=sum(S); SN=sum(N);
MWer=mean(Wer);
JWer=100*(SS+SD+SI)/SN;





fprintf('Opt: '); fprintf('%d ', Opt);
fprintf(' Wer: '); fprintf('%.2f ',Wer);
fprintf('\nMWer:%.2f, JWer:%.2f, SI:%d, SD:%d, SS:%d, SN:%d\n',MWer,JWer,SI,SD,SS,SN);



function [Wer,I,D,S,N]=ReRes1Exp(Opt,ResRoot,YDir)
%Read Result for One Experiment
ldc=length(YDir); %length of dir counter
s=sprintf('_%d',Opt(1:4));
TrOpt1=num2str(Opt(5));
TrOpt2=num2str(Opt(6));
TeOpt1=num2str(Opt(7));
TeOpt2=num2str(Opt(8));
I=zeros(1,ldc);
D=zeros(1,ldc);
S=zeros(1,ldc);
N=zeros(1,ldc);
Wer=zeros(1,ldc);
fprintf('Reading of %d:\n',ldc);
for dc=1:ldc %dir counter
    do=[ResRoot '/FE' s '/Feat/' YDir{dc}];    
    [p1,b1]=fileparts(do); [p2,b2]=fileparts(p1); [p3,b3]=fileparts(p2);
    ResDir=[p3 '/Res']; [x,x,x]=mkdir(ResDir);
    Id=[b2 '_' b1 '_' TrOpt1 '_' TrOpt2 '_' TeOpt1 '_' TeOpt2]; %Identifier: Dir + TestOptions    
    %
    WerF=[ResDir '/' Id '_Wer.txt']; %WerF     
    [Wer(dc),I(dc),D(dc),S(dc),N(dc)]=ReWerF(WerF,do);
    
    
    fprintf('%d ',dc); if mod(dc,30)==0; fprintf('\n'); end
    
    
end

fprintf('\n');    


function [Wer,I,D,S,N]=ReWerF(WerF,do)
%

if ~exist(WerF,'file')
    fprintf('ERROR: Doesnt exist %s\n',WerF);
%     Wer=50;
%     I=0;
%     D=0;
%     S=1;
%     N=2;   
    Wer=NaN;
    I=NaN;
    D=NaN;
    S=NaN;
    N=NaN;  
else
    

%Analize if WerF generated afeter/before FETrTeDir generates ParamUsed.txt 
A=dir([do '/ParamUsed.txt']);J=A(1).datenum; JT=datestr(J);
A=dir(WerF);                 W=A.datenum;  WT=datestr(W);
if J>W;   
    warning('Reading a old WerF (%s), generated before last FETrTeDir (%s) \n',WT,JT); 
    system(['cat ' WerF]); 
    pause, 
end
        

% system(['cat ' WerF]); 
fi=fopen(WerF,'r');
l = fgetl(fi);
while ischar(l)
    if ~isempty(strfind(l,'%WER'))
    
        
        C = strsplit(l);
        
        N=str2double(C{6}(1:end-1));        
        %sprintf('%s ',C{:});
        %H=str2double(C{4})
        I=str2double(C{7});
        D=str2double(C{9});
        S=str2double(C{11});  
        Wer=str2double(C{2});
        %WerJ=100*(S+D+I)/N;
        %AJ=100*(H-I)./N

    end
    l = fgetl(fi);
end

fclose(fi);

end


