function AllRec(ExeK) 
%All Recognition
%ExeK = 'a' (addpath) 'm' (matlab exe) 's' (sequential exe) 'p' (paralel) 
%'r' (read result) 'e' (errors of StEO)

addpath('./Fun'); 
addpath('../Common/Matlab'); 

%Select options manually
ExMach  = 'GRID'; %Execution Machine 'GPU' 'GRID' 'LAPT' 'ALH'
DBSize  ='All'; %'All' %Database Size (files analized per folder): 25 (first 25), R25 (random 25) .... or All
%SDBase  ='FBKGEDIRHA'; %Speech DataBase: A2, FBKGEDIRHA, ...
SDBase  = 'CHIME3'; 
%ARecSt  ={'FETr'};
ARecSt   ={'Tr'};
%ARecSt  = {'FETe'};

%Execution Options. Recomended only integer (not real 0.01) 
%ON MONDAY: See the next results: 40x11Fmllr Spn and 40x1Dnn
FEOpt1   = [0]; %1 2% (Spn in FE_0_0_0_0), 0 (Gmm), 1 (Spn), 2 (Dnn)
FEOpt2   = [0];%1% -1 clean, 0 noisy, 1 enh, 2 enh+unc
FEOpt3   = [0]; %0,1%  0 'Gmm'; 1 'Spn'; 2 'SpnMultO';  3 'SpnMultO_EM'; 
FEOpt4   = [0]; %1:3% 0 (40x1Fbank), 1 (40x11Fbank), 2 (40x1Fmllr), 3 (40x11Fmllr)

TrOpt1   = [0]; %0, 'SpnMod_SpnMultO_NoMvn';  1, SpnMod_SpnMultO_EM_NoMvn';
TrOpt2   = [0];
TeOpt1   = [0]; %0:1984
TeOpt2   = [0]; 

%Execution external extra Options 
ExOpt.TrNS      = 1250; % 100000 Training Number of Samples (for P&D algorithm) usually 1250
ExOpt.TrDevR    = 0.3; % Training Developtment Ratio number of samples
ExOpt.PDFiR     = 10; % P&D Finetuning (EM, Discriminative) Ration number of samples
ExOpt.MvnK      = 'NoMvn'; %NoMvn for Tr, GMvn for FETr and Te (or better set at feature extraction)
ExOpt.SpnTrK    ={'Dnn'}; %'Spn_EM','Gmm_EM' % Spn Training Kind 'Dnn', 'Gmm_EM', 'Spn_EM', 'SpnMultO_CE''.... 
ExOpt.FeatK      = '40x1Fmllr'; 

ExOpt.SpnVers  = 2; %Spn Version 1 or 2 
ExOpt.MixTrDevSamp = 0; %Mix Tr

ExOpt.NG        = 7; %Number of Gaussians per dimension
ExOpt.L1        = 40; % P&D convolutional feature dimension 1
ExOpt.L2        = 1; % P&D convolutional feature dimension 2
ExOpt.BatchS    = 10; %Batch Size 256 for Kaldi,

ExOpt.numIterPD = 20; %Max Number of P&D Iterations
ExOpt.numIterEM = 20; %Max Number of EM, Discriminative... Iterations
ExOpt.UpWeMeSi  = [1 1 1]; %Uptadate Weights, Mean and Variances flags

ExOpt.DBSize = DBSize;
ExOpt.SDBase = SDBase;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Add all paths and fill P. IMPORTANT: the order in filling P must be the same as the input of RecDir)
[P.SMRoot, P.SoftRoot, P.SpeechRoot, ResRoot, P.RecRoot, P.ExtraFunRoot, P.KaldiTrunkRoot, P.ExOptF, AsrResRoot,JHome]=AddSMPath(ExeK,ExOpt); 
DBaseRoot=[P.SpeechRoot '/' SDBase '_All']; 

%
[TrDir,TeDir]=DBaseYXDir(SDBase,DBaseRoot); 

%
switch ExeK
    case {'m', 's', 'p', 'pc' 'e'}        
        
        for stc=1:length(ARecSt) %stage counter
            RecSt=ARecSt{stc}; 
            
            switch RecSt
                case 'FETr'                    
                    YDir=TrDir;
                    TeOpt1=TeOpt1(1); TeOpt2=TeOpt2(1); 
                    TrOpt1=TrOpt1(1); TrOpt2=TrOpt2(1); 
                    JWaitBN='-1';
                    JMemMa='2G';
                    
                case 'Tr'
                    YDir={TrDir{1}};                    
                    %TeOpt1=0; TeOpt2=0;   
                    JWaitBN='FETr';
                    JMemMa='2G';
                    
                    
                case 'FETe'
                    YDir=TeDir;
                    JWaitBN='Tr';
                    JMemMa='2G';                    
            end           
            
            
            %Training or Front End            
            OptV=combvec(FEOpt1,FEOpt2,FEOpt3,FEOpt4,TrOpt1,TrOpt2,TeOpt1,TeOpt2);
            

            i=1;
            
                       
            for oc=1:size(OptV,2) %options counter                   
                Opt=OptV(:,oc); s=sprintf('_%d',Opt(1:4));             
                
                for dc=1:length(YDir) %dir counter 
                %for dc=17 %dir counter     
                    
                    do=[ResRoot '/FE' s '/Feat/' YDir{dc}];                    
                    dy=[DBaseRoot '/' YDir{dc}]; 
                    
                    OptId=sprintf('_%d',Opt);
                    DirId=strrep(YDir{dc},'/','_');         
                    
                    JP.JId=['JId' OptId '_' DirId]; %Job Identifier                                                         
                    JP.JName=[RecSt OptId];
                    JP.JWait=[JWaitBN OptId];                     
                    JP.JMemMa=JMemMa;
                    
                    S(i)=RecDirMatComp(do,dy,P,Opt,RecSt,ExeK,JP);                    
                    i=i+1;           
                
                end            
            end            
        end
        
        
    case 'c'
        %Compile RecDir and RSync with Grid      
       %MakeRecDir(P.SMRoot,P.SoftRoot,P.RecRoot,P.ExtraFunRoot);          
        [xx,GHomeSyn]=Juan2GridPathJobC({'xx'},'r',AsrResRoot,JHome,getenv('username'),'xx','xx',ExMach);         
       RSyncGridPr([AsrResRoot '/AsrEngine'],GHomeSyn,ExMach);
        
         
    case 'r'
        %Read results
        AnalRes(ResRoot,TeDir,ExMach,AsrResRoot,JHome,P,FEOpt1,FEOpt2,FEOpt3,FEOpt4,TrOpt1,TrOpt2,TeOpt1,TeOpt2);       
        
end


switch ExeK
    case {'s','p', 'pc', 'e'}   
        ParSeqShExe(S,ExeK,ResRoot,P.KaldiTrunkRoot,P.ExOptF,ExMach,AsrResRoot,JHome);              
end
        

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function S=RecDirMatComp(do,dy,P,Opt,RecSt,ExeK,JP)
% 

switch ExeK    
    
    case 'm'
       RecDir(do,dy,...
       P.SMRoot,P.SoftRoot,P.SpeechRoot,P.RecRoot,P.ExtraFunRoot,P.KaldiTrunkRoot,P.ExOptF,...
       RecSt,...
       num2str(Opt(1)),num2str(Opt(2)),num2str(Opt(3)),num2str(Opt(4)),num2str(Opt(5)),num2str(Opt(6)),num2str(Opt(7)),num2str(Opt(8)));
       S=-1;
    
    case {'s', 'p', 'pc' 'e'}
        
        %do and dy, in Command Options (co)        
        co=[do ' ' dy ' ']; 
        %P in co
        FN=fieldnames(P); 
        for i=1:length(FN)
            co=[co ' ' P.(FN{i})];
        end
        %RecSt in co
        co=[co ' ' RecSt];        
        %Opt in co
        s=sprintf(' %d',Opt(:));
        co=[co ' ' s];

        %Mat Program
        MatP=[P.SMRoot '/JuanFE/Recognizer/Fun/bin/RecDirBin ' co];
        
        %Shell Command
        [~, UName]=system('whoami'); JP.UName = strtrim(UName);            
        JP.McrRoot = matlabroot;        
        ShC=[P.ExtraFunRoot '/ParSeqExe/ExeMatPr.sh ' JP.JId ' ' JP.UName ' ' JP.McrRoot ' ' MatP];
        
        %Task
        S=JP;
        S.ShC=ShC;      

end

