function P=VadPit4EmbClParam(P,ys)
%
[P.TempP.ns,NMic]=size(ys);

%Basic Parameters
P.FLSec     = 0.032; %Frame Length in seconds
P.FSSec     = 0.010; %Frame Shift in seconds
P.PhLSec    = 0.20; %Ph Lenght in Seconds (inverse of the famous [3-7] Hz, phone/sec) 
P.BatchSSec = 20; %Batch Size in Sec (the signal is very long 1min and is analyzed by batches)
P.MaPitHz   = 270; %Max Pitch (Hz) (270 Hz)
P.MiPitHz   = 80; %Min Pitch (Hz) (80 Hz)

%Derived Parameters
P.FL        = P.FSamp*P.FLSec; 
P.FS        = P.FSamp*P.FSSec; 
P.BatchSFr  = round(P.BatchSSec/P.FSSec); %Batch Size in Frames
P.BatchEFr  = round(P.BatchSFr/3); %Batch Edges in Frames
P.FillFrN   = floor((1+P.FL)/P.FS); %Fill Frame Number (7)

P.PhL       = round(P.PhLSec/P.FSSec); 
P.FL        = P.FSamp*P.FLSec; 
P.FS        = P.FSamp*P.FSSec; 
P.TempP.nf  = ceil((P.TempP.ns-P.FL)/P.FS); %number of frames 
P.MiPitSa=round(P.FSamp/P.MaPitHz);
P.MaPitSa=round(P.FSamp/P.MiPitHz);


%
P.ARoomN={'-'};  

