function [vad,pit,P]=VadPit4EmbCl(x,FSamp)
%Vad For Clean speech signal


%Read Param
P.FSamp=FSamp;
P=VadPit4EmbClParam(P,x);

%Execute Vad in Batches
[vad,pit]=BlockProc(x,x,P.TempP.nf,'-1',P,x,x);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [Fbxest,pxest]=BlockProc(ym,ys,nf,Room,P,xm,xs)
%Block Enhancement. Each block is 1+3+1 seconds
%ym: y mono signal
%ys: y stereo or array signal
%

[ly, MicN]=size(ys);
[ly, MicNM]=size(ym);



%
Fbxest=zeros(1,nf);
pxest=zeros(1,nf);

BatchN=ceil(nf/P.BatchSFr);
fprintf('Block processing with BatchN %d:\n',BatchN);

for i=1:BatchN
%for i=22
    sff=(i-1)*P.BatchSFr+1; eff=i*P.BatchSFr; %start and end filling frames
    %sfs=(sff-1)*P.FS+1; efs=eff*P.FS;
    sf=(sff-P.BatchEFr); ef=(eff+P.BatchEFr)+P.FillFrN; %start and end frames    
    ss=(sf-1)*P.FS+1; es=ef*P.FS; %start and end samples
               
    [ymb,xmb,ysb,xsb]=BatchSign(ym,ys,ly,MicNM,MicN,ss,es,xm,xs);    
    fprintf('%d ',i);   if mod(i,30)==0; fprintf('\n'); end
    
    %
    [Fbxestb,pxestb]=VadPit4Cl(ymb,ysb,Room,P,xmb,xsb);                           

 

    int2=P.BatchEFr:(P.BatchSFr+P.BatchEFr-1);    
    
    Fbxest(:,sff:eff)=Fbxestb(:,int2);
    pxest(sff:eff)=pxestb(int2);

    
    
end


pxest=pxest(1:nf);
Fbxest=Fbxest(:,1:nf);
fprintf('\n');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [ymb,xmb,ysb,xsb]=BatchSign(ym,ys,ly,MicNM,MicN,ss,es,xm,xs)
%

int=ss:es; li=length(int); nzi=(int>=1)&(int<=ly); 
intb=1:li;    
intb=intb(nzi);     
int=int(nzi); 
ymb=zeros(li,MicNM);
xmb=zeros(li,MicNM); 
ysb=zeros(li,MicN);
xsb=zeros(li,MicN); 

ymb(intb,:)=ym(int,:);
xmb(intb,:)=xm(int,:);
ysb(intb,:)=ys(int,:);
xsb(intb,:)=xs(int,:);


