function [Vad, Pit]=VadPit4Cl(y,ys,Room,P,x,xs,kind)
%Vad and Pitch For Clean
%y: have to be around 10 seconds



%Parameters
HTh=0.6; %Harmonicity Thr ([0-1])
HPhL=round(P.PhL/2); %Half Phone Length (in frames)
SNRTh=3; %SNR Threshold
PosInt=6/5; %6/5 pitch Position Interval of search around mean ([1,2])

%Segmentation
[My nf]=Segmx(y,P.FL,P.FS);

%High Harmonicity
[x, x, x, R]=M2AC(My);
[v,p]=max(R(P.MiPitSa:P.MaPitSa,:)); H=v./R(1,:); H(isnan(H))=0; 
Pos=p+P.MiPitSa-1; %pitch Position
HiH=H>HTh;

%High Energy
E=sqrt(R(1,:)); %Energy magnitude (R gives normalized by the number of samples)
[HiE,th]=MagOrdThr(E,'Juan');

%Voice
HiEDi=DilateF(HiE,HPhL); %We dilate because HiE and HiH are very cut
HiHDi=DilateF(HiH,HPhL);
Vo=HiEDi&HiHDi; %Voiced (High Energy and Harmonicity)


%Unvoice
VoDi=DilateF(Vo,HPhL); %Voiced Dilate
SiE=mean(E(not(VoDi))); %Silence Energy
SNR=20*log10(E/SiE); %SNR
PUn=VoDi&not(Vo); %Possible Unvoiced
Un=SNR>SNRTh&PUn; %Unvoiced


switch kind    
    
    case 0 %Vad Siddharth paper        
        VoUn=Vo|Un; %Voiced Unvoice
        Vad=ModeF(VoUn,HPhL); %Vad
        
    case 1     %(SNR+Dil)
        Vad=SNR>SNRTh;
        Vad=DilateF(Vad,HPhL); %Voiced Dilate
        
    case 2     %(SNR)
        Vad=SNR>SNRTh;
           
        
end

%Pitch
Vo=HiH&Vad; %Final Voice (only where High Harmonicity and Vad)
MePos=mean(Pos(Vo)); %we include HiH to avoid the borders of Vo
if isnan(MePos); MePos=mean([P.MiPitSa P.MaPitSa]); end %if Vo is all zeros, this avoids error
MaPos=round(MePos*PosInt); MiPos=round(MePos/PosInt);



[v,p]=max(R(MiPos:MaPos,:));
Pos=p+MiPos-1; %pitch Position
Pos(not(Vo))=0;

%Final Pit
Pit=Pos-1; Pit(not(Vo))=0;

% subplot(311), jplot(y)
% subplot(312), jplot(Vad)
% subplot(313), jplot(Pit)
% pause






