function RunExample
%Run Example for Vad and Pitch estimator for Clean Embbed signal 


%
addpath('./Common')

%Path of signal to read
EmbRoot='/home/jmorales/SpeechData/CHIME3_All/Emb';
bn='F04_141111_030_BUS';
embf=[EmbRoot '/' bn '.wav'];
infof=[EmbRoot '/' bn '.txt'];

%Read signal and Info
[xs, FSamp]=audioread(embf); x=xs(:,1);


%XVad
[XVad,XPit,P]=VadPit4EmbCl(x,FSamp);


%XUad from info
P.Info=ReEmbInfo(infof);
XIsol=Info2OrTSLoc(xs, xs, P.Info);
XUad=HIsol2Uad(XIsol,P);


%Plot
subplot(311), jplot(x), title('Signal')
subplot(312), jplot(XVad), title('XVad')
subplot(313), jplot(XUad), title('XUad (given by Info)')





       




        




