function [hx,th]=MagOrdThr(sxi,k)
%Manitude Order Thresholding (binarization)
%sx: soft x (En=sqrt(mean(My.^2));)
%hx: hard x (vad)


switch k
    case 'Juan'
        sx=sxi(:);
        mu=mean(sx); th=mu+2*std(sx(sx<mu)); %Juan Formula
        hx=sxi>th;
        
    case 'Otsu'
        th = graythresh(sxi);
        hx=sxi>th;
end