function vad=MagOrdVad(y,P)
%Magnitude Order VAD
%

VadP=EnergyVadP(y,P);
%VadP=VoiceboxVadP(y,P,P.Temp.nf);
%VadP=PitVadP(y,P);
%VadP=G729Vad(y,P);

% %
% vad=BlockEVad(Y,P.UttL);
% N=IntMKnownP(Y,not(vad),P.FLFr); N(not(vad))=Y(not(vad));
% X=Y-N;
% vad=MagOrdThr(X);
% vad=ModeF(vad*1,P.UttL/5);

%
vad=MagOrdThr(VadP);


vad=ModeF(vad*1,P.PhL);

%
% subplot(311), plot(y), xlim([1 length(y)])
% subplot(312), plot(VadP), ylim([0 1.2])
% subplot(313), plot(vad), ylim([0 1.2])
% pause



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function VadP=EnergyVadP(y,P)
%
[My nf]=Segmx(y,P.FL,P.FS);
% %Autocorr
% [x, x, x, R]=M2AC(My);
% [v,p]=max(R(P.MiPitSa:P.MaPitSa,:)); h=v./R(1,:); h(isnan(h))=0; [h,x]=MeanF(h,hw); 
% En=sqrt(R(1,:)); %
M=sqrt(mean(My.^2));
E=log(M);
VadP=MeanF(E,round(P.PhL/2));

% subplot(311), plot(M)
% subplot(312), plot(E)
% subplot(313), plot(VadP)
% pause


function VadP=PitVadP(y,P)
%
HTh=0.70;
VF=2;
SnrTh=3;
py=VBoxPitch(y,P,HTh,VF,'Rapt',-1);
%py=YinPitch(y,P,HTh,SnrTh,VF,-1);
VadP=zeros(1,P.TempP.nf);
VadP(py~=0)=1;

function VadP=VoiceboxVadP(y,P,nf)
%Single Channel VAD
pp.ti=P.FSSec*1000;
vs=vadsohn(y,P.FSamp,'a',pp);
vs=vs(1:P.FS:end);
vs=vs(1:nf);
VadP=vs;





function vad=BlockEVad(E,UttL)
%
nf=length(E);
vad=zeros(1,nf);
L=UttL;
E2=[E(1)*ones(1,L) E E(nf)*ones(1,2*L)];
for s=1:L:nf  
    e=s+L-1;     
    int=(s-L:e+L)+L;   
    a=MagOrdThr(E2(int));     
    vad(s:e)=a(L+1:2*L);    
end
vad=vad(1:nf);


