function [s,P]=Signals(k,subk,P)
%All outputs are normalized and columned
%P: Parameters structure (P.N2pi, P.NSamp, P.p, ....);


%Root paths
NA2Dir='/clusterFS/home/user/jamc/SPEECHDATA/A2_All/noises/';


switch k
    
   case 'GammSign' %Gammatone Signal    
        [s,P.CG,P.GamCFHz]=GammSignal(P.DurSec,P.PitHz,P.M,P.FSampHz);
        
    case 'PhoJuan'        
         s = ReInt162NDouble([P.SMRoot '/FEJuan/Common/Sounds/Phones/' subk '.snd']);
         P.FSamp=8000;
    case 'VowTDS'
        fn=[PhoDir subk 'TDS.asc'];
        s = load(fn); 
    case 'PhonRuleSynth'      
        [s,P.M]=PhonRuleSynth(subk,P.FSamp,P.f0,P.N2pi,P.MinMS,P.NSamp);        
    case 'PerPul'       
        f=[0 0.2 0.4 0.6 0.8 1]; M=[1 1 1 1 1 1];
        s=GetPerSignal(P.p,f,M);         
    case 'PerSin'
        s=RepPerSignal(P.p,P.NSamp);  
        %s=SinSignal(P.p,P.NSamp);        
        
    case 'Cons'
        s = ReInt162NDouble([VowDir subk '.snd']);          
    case 'NA2'       
        s=ReInt162NDouble([NA2Dir subk '.raw']);         
        
end

l=length(s);
s=reshape(s,[l 1]); 
%s=s/max(s);



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function s=GetPerSignal(pit,f,M)
%GIVE A VECTOR OF ARMA Train Pulse depending on Magnitude Shape
%pit: pitch vector
%f: Corresponding frequencies [0 1 (is Nyquist)]  
%M: Magnitude shape
%p: order should be 2*length(M)+2;
%
pit=[pit(1)*ones(1,1000-1) pit]; l=length(pit); 
imp=zeros(1,l); imp(1)=1; a=pit(1);
for i=1:l
    a=a-1; if a<=0; imp(i)=1; a=pit(i); end
end
%    
p=2*length(M)+2;
b=fir2(p,f,M); a=1; 
s = filter(b,a,imp);
s = s(1000:end);
s=s/max(s);


function x=RepPerSignal(T,N)
%Repeated Period Signal
Np=ceil(N/T(1)); 
%xf=randn(1,T);
xf=zeros(1,T); xf(1)=1;
x=repmat(xf,[1 Np]); x=x(1:N);


function x=SinSignal(T,N)
%Repeated Period Signal
fc=cumsum(1./T);
x=sin(2*pi*fc)+sin(4*pi*fc);



