function [s,M]=PhonRuleSynth(k,fs,f0,N2pi,MinMS,nsamps)
%Phone Rules-based Synthesis
%s: signal. [f,M]: ideal Msd (not for normalized signal). 
%Formants position and formants BandWidth
if (k=='i'); F=[320 2500]; end
if (k=='e'); F=[700 1800]; end
if (k=='a'); F=[1000 1400]; end
if (k=='o'); F=[500 1000]; end
if (k=='u'); F=[320 800]; end
BW = [50,  70];  
%Create filter
r = exp(-pi*BW/fs);     % Pole radii
theta = 2*pi*F/fs;      % Pole angles
poles = r .* exp(1i*theta); % Complex poles 
B=1;  A=real(poly([poles,conj(poles)]));
%Synt
pit=round(fs/f0); sig=zeros(nsamps,1); sig(1:pit:end)=1;
s = filter(B,A,sig);
%Msd
E=abs(1./fft(A',N2pi)); 
H=zeros(N2pi,1); lh=round(0:N2pi*f0/fs:N2pi-1); H(lh+1)=1;
M=H.*E;
if mod(N2pi,2)==0; NFTh=1+N2pi/2; 
else NFTh=(N2pi+1)/2; end
M=M(1:NFTh);
i=M<MinMS; M(i)=MinMS; 




